/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.graph.IObjectDirectedGraph;
import edu.ksu.cis.indus.common.graph.IObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphReachabilityPredicate<N extends IObjectNode<N, O>, O>
implements IPredicate<O> {
    private final N destNode;
    private final boolean forward;
    private final IObjectDirectedGraph<N, O> graph;

    public GraphReachabilityPredicate(@NonNull @Immutable N theDestNode, boolean forwardDir, @NonNull @Immutable IObjectDirectedGraph<N, O> theGraph) {
        this.destNode = theDestNode;
        this.forward = forwardDir;
        this.graph = theGraph;
    }

    @Override
    public <V extends O> boolean evaluate(@Immutable V srcObject) {
        N _srcNode = this.graph.queryNode(srcObject);
        return this.destNode != null && _srcNode != null && this.graph.isReachable(_srcNode, this.destNode, this.forward);
    }
}

