/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.graph.INode;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphInfo<N extends INode<N>> {
    private final TObjectIntHashMap node2index = new TObjectIntHashMap();
    @NonNullContainer
    private final List<N> nodes = new ArrayList<N>();

    @Empty
    public GraphInfo() {
    }

    public final int getIndexOfNode(@NonNull @Immutable N node) {
        int _result;
        if (this.node2index.containsKey(node)) {
            _result = this.node2index.get(node);
        } else {
            _result = this.getNodes().indexOf(node);
            this.node2index.put(node, _result);
            assert (_result != -1);
        }
        return _result;
    }

    @NonNull
    @NonNullContainer
    @Functional
    public final List<N> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public boolean removeNode(@NonNull @Immutable N node) {
        this.node2index.remove(node);
        return this.nodes.remove(node);
    }

    public final void shapeChanged() {
        this.node2index.clear();
    }

    protected final boolean addNode(@NonNull @Immutable N node) {
        boolean _result = this.nodes.add(node);
        if (_result) {
            this.node2index.put(node, this.nodes.size() - 1);
        }
        return _result;
    }
}

