/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IEdgeLabelledNode;
import edu.ksu.cis.indus.common.graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeLabelledNode<T extends EdgeLabelledNode<T>>
extends Node<T>
implements IEdgeLabelledNode<T> {
    @NonNullContainer
    final Map<IEdgeLabel, Collection<T>> label2inNodes = new HashMap<IEdgeLabel, Collection<T>>();
    @NonNullContainer
    final Map<IEdgeLabel, Collection<T>> label2outNodes = new HashMap<IEdgeLabel, Collection<T>>();

    protected EdgeLabelledNode(@Immutable @NonNull @NonNullContainer Collection<T> preds, @Immutable @NonNull @NonNullContainer Collection<T> succs) {
        super(preds, succs);
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<IEdgeLabel> getIncomingEdgeLabels() {
        return Collections.unmodifiableCollection((Collection)this.label2inNodes.keySet());
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<IEdgeLabel> getOutGoingEdgeLabels() {
        return Collections.unmodifiableCollection((Collection)this.label2outNodes.keySet());
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<T> getPredsViaEdgesLabelled(@NonNull IEdgeLabel label) {
        return MapUtils.queryCollection(this.label2inNodes, label);
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional
    public Collection<T> getSuccsViaEdgesLabelled(@NonNull IEdgeLabel label) {
        return MapUtils.queryCollection(this.label2outNodes, label);
    }

    @Override
    @Functional
    public final boolean hasIncomingEdgeLabelled(@NonNull IEdgeLabel label) {
        return this.label2inNodes.containsKey(label);
    }

    @Override
    @Functional
    public final boolean hasOutgoingEdgeLabelled(@NonNull IEdgeLabel label) {
        return this.label2outNodes.containsKey(label);
    }
}

