/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDirectedGraphTest
extends IndusTestCase {
    protected IDirectedGraph dg;

    public final void testAddEdgeFromTo() {
        this.localtestAddEdgeFromTo();
    }

    public final void testGetBackEdges() {
        Collection _cycles = this.dg.getCycles();
        Collection _backedges = this.dg.getBackEdges();
        HashSet _nodes = new HashSet();
        AbstractDirectedGraphTest.assertTrue((_cycles.isEmpty() == _backedges.isEmpty() ? 1 : 0) != 0);
        for (Pair _edge : _backedges) {
            _nodes.add(_edge.getFirst());
            _nodes.add(_edge.getSecond());
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(_nodes));
        for (Pair _edge : _backedges) {
            INode _src = (INode)_edge.getFirst();
            INode _dest = (INode)_edge.getSecond();
            AbstractDirectedGraphTest.assertTrue((boolean)_src.getSuccsOf().contains(_dest));
            AbstractDirectedGraphTest.assertTrue((boolean)this.dg.isReachable(_dest, _src, true));
            boolean _flag = false;
            for (Collection collection : _cycles) {
                _flag |= collection.contains(_src);
                _flag |= collection.contains(_dest);
            }
            AbstractDirectedGraphTest.assertTrue((boolean)_flag);
        }
    }

    public final void testGetCommonsReachablesFrom() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] _flags = blArray;
        for (INode _n1 : this.dg.getNodes()) {
            for (INode _n2 : this.dg.getNodes()) {
                int _k = 0;
                while (_k <= 1) {
                    Collection<INode> _c1 = this.dg.getReachablesFrom(_n1, _flags[_k]);
                    int _l = 0;
                    while (_l <= 1) {
                        Collection<INode> _c2 = this.dg.getReachablesFrom(_n2, _flags[_l]);
                        Collection<INode> _c3 = this.dg.getCommonReachablesFrom(_n1, _flags[_k], _n2, _flags[_l]);
                        AbstractDirectedGraphTest.assertTrue((boolean)_c3.containsAll(SetUtils.intersection(_c2, _c1)));
                        AbstractDirectedGraphTest.assertTrue((boolean)SetUtils.intersection(_c2, _c1).containsAll(_c3));
                        ++_l;
                    }
                    ++_k;
                }
            }
        }
    }

    public final void testGetCycles() {
        Collection _cycles = this.dg.getCycles();
        for (Collection collection : _cycles) {
            INode _node = (INode)collection.iterator().next();
            AbstractDirectedGraphTest.assertTrue((boolean)this.dg.isReachable(_node, _node, true));
        }
        this.localtestGetCycles();
    }

    public final void testGetDAG() {
        IDirectedGraph _dag = this.dg.getDAG();
        List _sccTD = _dag.getSCCs(true);
        Iterator _i = _sccTD.iterator();
        int _iEnd = _sccTD.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection _scc = _i.next();
            AbstractDirectedGraphTest.assertTrue((_scc.size() == 1 ? 1 : 0) != 0);
            ++_iIndex;
        }
        AbstractDirectedGraphTest.assertTrue((String)(_dag.getCycles() + " "), (boolean)_dag.getCycles().isEmpty());
    }

    public final void testGetSCCs() {
        Collection _sccsTrue = this.dg.getSCCs(true);
        this.checkSCCReachability(_sccsTrue);
        Collection _sccsFalse = this.dg.getSCCs(false);
        this.checkSCCReachability(_sccsFalse);
        AbstractDirectedGraphTest.assertTrue((boolean)_sccsTrue.containsAll(_sccsFalse));
        AbstractDirectedGraphTest.assertTrue((boolean)_sccsFalse.containsAll(_sccsTrue));
        this.localtestGetSCCs();
    }

    public final void testGetSinks() {
        Collection _sinks = this.dg.getSinks();
        for (INode _node : _sinks) {
            AbstractDirectedGraphTest.assertTrue((boolean)_node.getSuccsOf().isEmpty());
        }
        for (INode _node : this.dg.getNodes()) {
            AbstractDirectedGraphTest.assertTrue((boolean)SetUtils.intersection(_node.getPredsOf(), _sinks).isEmpty());
        }
    }

    public final void testGetSources() {
        Collection _sources = this.dg.getSources();
        for (INode _node : _sources) {
            AbstractDirectedGraphTest.assertTrue((boolean)_node.getPredsOf().isEmpty());
        }
        for (INode _node : this.dg.getNodes()) {
            AbstractDirectedGraphTest.assertTrue((boolean)SetUtils.intersection(_node.getSuccsOf(), _sources).isEmpty());
        }
    }

    public final void testGetSpanningSuccs() {
        HashMap _spanningSuccs = new HashMap(this.dg.getSpanningSuccs());
        HashSet _temp = new HashSet();
        AbstractDirectedGraphTest.assertEquals(_spanningSuccs, this.dg.getSpanningSuccs());
        for (Collection _succs : _spanningSuccs.values()) {
            _temp.addAll(_succs);
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(_spanningSuccs.keySet()));
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(_temp));
        for (INode _node : _temp) {
            AbstractDirectedGraphTest.assertTrue((CollectionUtils.cardinality(_node, _temp) == 1 ? 1 : 0) != 0);
        }
        _temp.addAll(_spanningSuccs.keySet());
        AbstractDirectedGraphTest.assertTrue((boolean)_temp.containsAll(this.dg.getNodes()));
    }

    public final void testIsAncestorOf() {
        this.localtestIsAncestorOf();
    }

    public final void testIsReachable() {
        this.localtestIsReachable();
    }

    public final void testPerformTopologicalSort() {
        List _sorted = this.dg.performTopologicalSort(true);
        List _nodes = this.dg.getNodes();
        AbstractDirectedGraphTest.assertTrue((_nodes.containsAll(_sorted) && _sorted.containsAll(_nodes) ? 1 : 0) != 0);
        if (this.dg.getCycles().isEmpty()) {
            for (INode _src : _sorted) {
                Collection _t = _sorted.subList(_sorted.indexOf(_src), _sorted.size() - 1);
                for (INode _dest : _t) {
                    AbstractDirectedGraphTest.assertFalse((boolean)this.dg.isReachable(_dest, _src, true));
                }
            }
        }
    }

    public final void testgetReachablesFrom() {
        Collection _nodes = this.dg.getNodes();
        for (INode _src : _nodes) {
            Collection<INode> _fReachables = this.dg.getReachablesFrom(_src, true);
            Collection<INode> _rReachables = this.dg.getReachablesFrom(_src, false);
            for (INode _dest : _nodes) {
                AbstractDirectedGraphTest.assertTrue((_fReachables.contains(_dest) == this.dg.isReachable(_src, _dest, true) ? 1 : 0) != 0);
                AbstractDirectedGraphTest.assertTrue((_rReachables.contains(_dest) == this.dg.isReachable(_src, _dest, false) ? 1 : 0) != 0);
            }
        }
    }

    public void testGetTails() {
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getTails().containsAll(this.dg.getSinks()));
    }

    protected final void extractPredSuccCopy(IDirectedGraph graph, Map preds, Map succs) {
        for (INode _node : graph.getNodes()) {
            preds.put(_node, new ArrayList(_node.getPredsOf()));
            succs.put(_node, new ArrayList(_node.getSuccsOf()));
        }
    }

    protected void localtestAddEdgeFromTo() {
    }

    protected void localtestGetCycles() {
    }

    protected void localtestGetSCCs() {
    }

    protected void localtestIsAncestorOf() {
    }

    protected void localtestIsReachable() {
    }

    private void checkSCCReachability(Collection sccs) {
        HashSet _nodes = new HashSet();
        HashSet _rest = new HashSet();
        for (Collection _scc : sccs) {
            _nodes.addAll(_scc);
            if (_scc.size() <= 1) continue;
            for (INode _srcNode : _scc) {
                _rest.clear();
                _rest.addAll(_scc);
                _rest.remove(_srcNode);
                for (INode _destNode : _rest) {
                    AbstractDirectedGraphTest.assertTrue((this.dg.isReachable(_srcNode, _destNode, true) && this.dg.isReachable(_srcNode, _destNode, false) ? 1 : 0) != 0);
                }
            }
        }
        AbstractDirectedGraphTest.assertTrue((boolean)this.dg.getNodes().containsAll(_nodes));
    }
}

