/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.graph;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.annotations.NumericalConstraint;
import edu.ksu.cis.indus.common.collections.Cache;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.FactoryBasedLazyMap;
import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.collections.MembershipPredicate;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.collections.TransformerBasedLazyMap;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Marker;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.graph.IDirectedGraph;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.IObjectDirectedGraph;
import edu.ksu.cis.indus.common.graph.MutableDirectedGraph;
import edu.ksu.cis.indus.common.graph.SCCRelatedData;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraphBuilder;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectedGraph<N extends INode<N>>
implements IDirectedGraph<N>,
Iterable<N> {
    private static int currCompNum;
    private static int dfsNum;
    int[] discoverTimes;
    @NonNullContainer
    private final Collection<Pair<N, N>> backedges = new ArrayList<Pair<N, N>>();
    private BitSet[] backwardReachabilityMatrix;
    private SimpleNodeGraphBuilder<N> builder;
    @NonNull
    private Map<Triple<N, N, Boolean>, Collection<N>> connectivityCache = new Cache<Triple<N, N, Boolean>, Collection<N>>(50);
    @NonNullContainer
    private final Collection<Pair<N, N>> crossedges = new ArrayList<Pair<N, N>>();
    private boolean dagExists;
    private int[] finishTimes;
    private BitSet[] forwardReachabilityMatrix;
    private boolean hasSCC;
    private boolean hasSpanningForest;
    @NonNullContainer
    private final Collection<N> pseudoTails = new HashSet<N>();
    private boolean pseudoTailsCalculated;
    private boolean reachability;
    @NonNullContainer
    private List<List<N>> scc;
    @NonNullContainer
    private final Collection<N> sinks = new HashSet<N>();
    private boolean sinksAreAvailable;
    @NonNullContainer
    private final Collection<N> sources = new HashSet<N>();
    private boolean sourcesAreAvailable;
    private Map<N, Set<N>> spanningSuccs;

    @NonNull
    @NonNullContainer
    @Functional
    public static <T extends INode<T>> Collection<List<T>> findCycles(@NonNull @NonNullContainer @Immutable Collection<T> nodes, @NonNull @NonNullContainer @Immutable Collection<Pair<T, T>> backedges) {
        ArrayList<List<T>> _result = new ArrayList<List<T>>();
        Collection<List<T>> _sccs = AbstractDirectedGraph.findSCCs(nodes);
        Iterator<List<T>> _j = _sccs.iterator();
        int _jEnd = _sccs.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            List<T> _scc = _j.next();
            if (_scc.size() == 1) {
                INode _node = (INode)_scc.iterator().next();
                if (_node.getSuccsOf().contains(_node)) {
                    _result.add(Collections.singletonList(_node));
                }
            } else {
                ArrayList<Pair<T, T>> _edges = new ArrayList<Pair<T, T>>(backedges);
                Iterator _i = _edges.iterator();
                while (_i.hasNext()) {
                    Pair _edge = (Pair)_i.next();
                    if (_scc.contains(_edge.getFirst()) && _scc.contains(_edge.getSecond())) continue;
                    _i.remove();
                }
                _result.addAll(AbstractDirectedGraph.findCyclesOccurringIn(_scc, _edges));
            }
            ++_jIndex;
        }
        return _result;
    }

    @NonNull
    @NonNullContainer
    @Functional
    public static <T extends INode<T>> Collection<List<T>> findSCCs(@NonNull @NonNullContainer @Immutable Collection<T> nodes) {
        ArrayList<List<T>> _result = new ArrayList<List<T>>();
        FactoryBasedLazyMap _node2srd = new FactoryBasedLazyMap(new HashMap(), new IFactory<SCCRelatedData>(){

            @Override
            public SCCRelatedData create() {
                return new SCCRelatedData();
            }
        });
        currCompNum = 0;
        dfsNum = 0;
        Stack _stack = new Stack();
        for (INode _n : nodes) {
            SCCRelatedData _nSRD = (SCCRelatedData)_node2srd.get(_n);
            if (_nSRD.getDfsNum() != 0) continue;
            AbstractDirectedGraph.calculateSCCs(nodes, _node2srd, _n, _stack, _result);
        }
        return _result;
    }

    @Immutable
    static <T extends INode<T>> void calculateSCCs(@NonNull @NonNullContainer @Immutable Collection<T> nodes, @NonNull @NonNullContainer Map<T, SCCRelatedData> node2srd, @NonNull @NonNullContainer @Immutable T node, @NonNull @NonNullContainer Stack<T> stack, @NonNull @NonNullContainer Collection<List<T>> sccs) {
        SCCRelatedData _nodeSRD = node2srd.get(node);
        _nodeSRD.setDfsNum(dfsNum);
        _nodeSRD.setHigh(dfsNum);
        stack.push(node);
        --dfsNum;
        Iterator<T> _j = IteratorUtils.filteredIterator(node.getSuccsOf().iterator(), new MembershipPredicate<T>(true, nodes));
        while (_j.hasNext()) {
            INode _succ = (INode)_j.next();
            SCCRelatedData _succSRD = node2srd.get(_succ);
            if (_succSRD.getDfsNum() == 0) {
                AbstractDirectedGraph.calculateSCCs(nodes, node2srd, _succ, stack, sccs);
                _nodeSRD.setHigh(Math.max(_nodeSRD.getHigh(), _succSRD.getHigh()));
                continue;
            }
            if (_succSRD.getDfsNum() <= _nodeSRD.getDfsNum() || _succSRD.getComponentNum() != 0) continue;
            _nodeSRD.setHigh(Math.max(_nodeSRD.getHigh(), _succSRD.getDfsNum()));
        }
        if (_nodeSRD.getHigh() == _nodeSRD.getDfsNum()) {
            INode _o;
            _nodeSRD.setComponentNum(++currCompNum);
            ArrayList<INode> _scc = new ArrayList<INode>();
            do {
                _o = (INode)stack.pop();
                node2srd.put(_o, _nodeSRD);
                _scc.add(_o);
            } while (_o != node);
            sccs.add(_scc);
        }
    }

    @Functional
    static <T extends INode<T>> boolean cycleNotRecorded(@NonNull @NonNullContainer @Immutable List<T> newCycle, @Immutable @NonNull @NonNullContainer Collection<List<T>> cycles) {
        boolean _result = true;
        ArrayList<T> _temp = new ArrayList<T>();
        Iterator<List<T>> _iter = cycles.iterator();
        int _iterEnd = cycles.size();
        int _iterIndex = 0;
        while (_iterIndex < _iterEnd && _result) {
            List<T> _cycle = _iter.next();
            if (_cycle.size() == newCycle.size()) {
                _temp.clear();
                _temp.addAll(_cycle);
                _temp.addAll(_cycle);
                _result = Collections.indexOfSubList(_temp, newCycle) == -1;
            }
            ++_iterIndex;
        }
        return _result;
    }

    @NonNull
    @NonNullContainer
    @Functional
    static <T extends INode<T>> Collection<List<T>> findCyclesOccurringIn(@NonNull @NonNullContainer List<T> scc, @NonNull @NonNullContainer Collection<Pair<T, T>> backedges) {
        LIFOWorkBag<Object> _wb = new LIFOWorkBag<Object>();
        Stack<INode> _dfsPath = new Stack<INode>();
        HashSet<List<T>> _result = new HashSet<List<T>>();
        MembershipPredicate _cyclePredicate = new MembershipPredicate(true, _dfsPath);
        MembershipPredicate _noncyclePredicate = new MembershipPredicate(false, _dfsPath);
        HashSet<Pair<T, T>> _backEdgesNotToUse = new HashSet<Pair<T, T>>(backedges);
        Iterator<Pair<T, T>> _k = backedges.iterator();
        int _kEnd = backedges.size();
        int _kIndex = 0;
        while (_kIndex < _kEnd) {
            Pair<T, T> _edge = _k.next();
            _backEdgesNotToUse.remove(_edge);
            _dfsPath.clear();
            INode _dest = (INode)_edge.getSecond();
            _wb.addWork(_dest);
            while (_wb.hasWork()) {
                Object _o = _wb.getWork();
                if (_o instanceof Marker) {
                    Object _temp = ((Marker)_o).getContent();
                    while (!_temp.equals(_dfsPath.peek())) {
                        _dfsPath.pop();
                    }
                    continue;
                }
                INode _node = (INode)_o;
                Collection<INode> _succsOf = AbstractDirectedGraph.getLimitedImmediateSuccsOf(_node, _backEdgesNotToUse, scc);
                _dfsPath.push(_node);
                Iterator<INode> _i = IteratorUtils.filteredIterator(_succsOf.iterator(), _cyclePredicate);
                while (_i.hasNext()) {
                    INode _ele = _i.next();
                    List _cycle = _dfsPath.subList(_dfsPath.indexOf(_ele), _dfsPath.size());
                    if (!AbstractDirectedGraph.cycleNotRecorded(_cycle, _result)) continue;
                    ArrayList _temp = new ArrayList(_cycle);
                    _result.add(_temp);
                }
                CollectionUtils.filter(_succsOf, _noncyclePredicate);
                if (_succsOf.isEmpty()) continue;
                Marker _marker = new Marker(_node);
                Iterator<INode> _j = _succsOf.iterator();
                int _jEnd = _succsOf.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    INode _ele = _j.next();
                    if (_jEnd > 1) {
                        _wb.addWork(_marker);
                    }
                    _wb.addWork(_ele);
                    ++_jIndex;
                }
            }
            _backEdgesNotToUse.add(_edge);
            ++_kIndex;
        }
        return _result;
    }

    @Immutable
    static <T extends INode<T>> int getFinishTimes(@NonNull @Immutable T node, @NonNull @NonNullContainer Collection<T> processed, @NonNull @NonNullContainer TIntObjectHashMap finishTime2node, int time) {
        processed.add(node);
        int _temp = time;
        ++_temp;
        for (INode _succ : node.getSuccsOf()) {
            if (processed.contains(_succ)) continue;
            _temp = AbstractDirectedGraph.getFinishTimes(_succ, processed, finishTime2node, _temp);
        }
        finishTime2node.put(++_temp, node);
        return _temp;
    }

    @Functional
    @NonNull
    @NonNullContainer
    static <T extends INode<T>> Collection<T> getLimitedImmediateSuccsOf(@NonNull @Immutable T node, @NonNull @NonNullContainer @Immutable Collection<Pair<T, T>> edgesNotToUse, @NonNull @Immutable Collection<T> nodes) {
        HashSet<T> _result = new HashSet<T>(node.getSuccsOf());
        for (Pair<T, T> _edge : edgesNotToUse) {
            if (!((INode)_edge.getFirst()).equals(node)) continue;
            _result.remove(_edge.getSecond());
        }
        _result.retainAll(nodes);
        return _result;
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Collection<Pair<N, N>> getBackEdges() {
        this.createSpanningForest();
        Collection<Pair<N, N>> _result = this.backedges.isEmpty() ? (Collection<Pair<N, N>>)Collections.emptyList() : Collections.unmodifiableCollection(this.backedges);
        return _result;
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    public Collection<N> getCommonReachablesFrom(@NonNull @Immutable N node1, boolean forward1, @NonNull @Immutable N node2, boolean forward2) {
        ArrayList<INode> _result;
        this.calculateReachabilityInfo();
        BitSet _n1 = forward1 ? this.forwardReachabilityMatrix[this.getIndexOfNode(node1)] : this.backwardReachabilityMatrix[this.getIndexOfNode(node1)];
        BitSet _n2 = forward2 ? this.forwardReachabilityMatrix[this.getIndexOfNode(node2)] : this.backwardReachabilityMatrix[this.getIndexOfNode(node2)];
        if (_n1.intersects(_n2)) {
            List _nodes = this.getNodes();
            _result = new ArrayList<INode>();
            BitSet _r = new BitSet();
            _r.or(_n1);
            _r.and(_n2);
            int _i = _r.nextSetBit(0);
            while (_i >= 0) {
                _result.add((INode)_nodes.get(_i));
                _i = _r.nextSetBit(_i + 1);
            }
        } else {
            _result = (ArrayList<INode>)Collections.emptyList();
        }
        return _result;
    }

    @Override
    @Functional
    @NonNull
    @NonNullContainer
    public final Collection<N> getConnectivityNodesFor(@NonNull @Immutable N node1, @NonNull @Immutable N node2, boolean forward) {
        Collection<N> _result = Collections.emptySet();
        if (this.hasCommonReachablesFrom(node1, forward, node2, forward)) {
            Triple<N, N, Boolean> _trp1 = new Triple<N, N, Boolean>(node1, node2, forward);
            if (this.connectivityCache.containsKey(_trp1)) {
                _result = this.connectivityCache.get(_trp1);
            } else {
                Triple<N, N, Boolean> _trp2 = new Triple<N, N, Boolean>(node2, node1, !forward);
                if (this.connectivityCache.containsKey(_trp2)) {
                    _result = this.connectivityCache.get(_trp2);
                } else {
                    _result = this.calculateConnectivityNodes(node1, node2, forward);
                    this.connectivityCache.put(_trp1, _result);
                }
            }
        }
        return _result;
    }

    @Override
    @NonNull
    @NonNullContainer
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    public final Collection<List<N>> getCycles() {
        return AbstractDirectedGraph.findCycles(this.getNodes(), this.getBackEdges());
    }

    @NonNull
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    public final SimpleNodeGraph<N> getDAG() {
        if (!this.dagExists) {
            this.builder = new SimpleNodeGraphBuilder();
            this.builder.createGraph();
            this.createSpanningForest();
            List _nodes = this.getNodes();
            for (INode _node : _nodes) {
                int _nodeIndex = _nodes.indexOf(_node);
                int _disTime = this.discoverTimes[_nodeIndex];
                int _finTime = this.finishTimes[_nodeIndex];
                this.builder.createNode(_node);
                for (INode _succ : _node.getSuccsOf()) {
                    this.builder.createNode(_succ);
                    int _succIndex = _nodes.indexOf(_succ);
                    if (this.discoverTimes[_succIndex] <= _disTime && this.finishTimes[_succIndex] >= _finTime) continue;
                    this.builder.addEdgeFromTo(_node, _succ);
                }
            }
            this.builder.finishBuilding();
            this.dagExists = true;
        }
        return (SimpleNodeGraph)this.builder.getBuiltGraph();
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public Collection<N> getNodesOnPathBetween(@NonNull @NonNullContainer Collection<N> nodes) {
        HashSet<INode> _result = new HashSet<INode>();
        TransformerBasedLazyMap _node2ancestorsMap = new TransformerBasedLazyMap(new HashMap(), new ITransformer<N, Collection<N>>(){

            @Override
            public Collection<N> transform(N key) {
                return AbstractDirectedGraph.this.getReachablesFrom(key, false);
            }
        });
        Iterator<N> _i = nodes.iterator();
        int _iEnd = nodes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            INode _node1 = (INode)_i.next();
            Collection<INode> _descendants = this.getReachablesFrom(_node1, true);
            Collection _intersection = SetUtils.intersection(nodes, _descendants);
            Iterator _j = _intersection.iterator();
            int _jEnd = _intersection.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                INode _node2 = (INode)_j.next();
                Collection _ancestors = (Collection)_node2ancestorsMap.get(_node2);
                Collection _ancestorsInGivenNodes = SetUtils.intersection(_ancestors, _descendants);
                _result.addAll(_ancestorsInGivenNodes);
                _result.add(_node2);
                ++_jIndex;
            }
            if (_jEnd > 0) {
                _result.add(_node1);
            }
            ++_iIndex;
        }
        return _result;
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Collection<N> getReachablesFrom(@NonNull @Immutable N root, boolean forward) {
        this.calculateReachabilityInfo();
        BitSet _matrix = forward ? this.forwardReachabilityMatrix[this.getIndexOfNode(root)] : this.backwardReachabilityMatrix[this.getIndexOfNode(root)];
        ArrayList<INode> _result = new ArrayList<INode>();
        List _nodes = this.getNodes();
        int _i = _matrix.nextSetBit(0);
        while (_i >= 0) {
            _result.add((INode)_nodes.get(_i));
            _i = _matrix.nextSetBit(_i + 1);
        }
        return _result;
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final List<List<N>> getSCCs(boolean topDown) {
        if (!this.hasSCC) {
            List _nodes = this.getNodes();
            Collection _sccs = AbstractDirectedGraph.findSCCs(_nodes);
            HashMap _node2scc = new HashMap();
            SimpleNodeGraphBuilder<List> _sngb = new SimpleNodeGraphBuilder<List>();
            _sngb.createGraph();
            for (List _scc : _sccs) {
                _sngb.createNode(_scc);
                for (INode _n : _scc) {
                    _node2scc.put(_n, _scc);
                }
            }
            for (List _scc : _sccs) {
                for (INode _n : _scc) {
                    for (INode _succ : _n.getSuccsOf()) {
                        if (_scc.contains(_succ)) continue;
                        _sngb.addEdgeFromTo(_scc, (List)_node2scc.get(_succ));
                    }
                }
            }
            _sngb.finishBuilding();
            Object _sng = _sngb.getBuiltGraph();
            List _r = _sng.performTopologicalSort(true);
            this.scc = CollectionUtils.collect(_r, _sng.getObjectExtractor());
            this.hasSCC = true;
        }
        ArrayList<List<N>> _result = new ArrayList<List<N>>(this.scc);
        if (!topDown) {
            Collections.reverse(_result);
        }
        return _result;
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Collection<N> getSinks() {
        if (!this.sinksAreAvailable) {
            this.sinks.clear();
            Iterator _i = this.getNodes().iterator();
            int _iEnd = this.getNodes().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                INode _node = (INode)_i.next();
                if (_node.getSuccsOf().isEmpty()) {
                    this.sinks.add(_node);
                }
                ++_iIndex;
            }
            this.sinksAreAvailable = true;
        }
        return Collections.unmodifiableCollection(this.sinks);
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Collection<N> getSources() {
        if (!this.sourcesAreAvailable) {
            this.sources.clear();
            Iterator _i = this.getNodes().iterator();
            int _iEnd = this.getNodes().size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                INode _node = (INode)_i.next();
                if (_node.getPredsOf().isEmpty()) {
                    this.sources.add(_node);
                }
                ++_iIndex;
            }
            this.sourcesAreAvailable = true;
        }
        return Collections.unmodifiableCollection(this.sources);
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Map<N, Set<N>> getSpanningSuccs() {
        this.createSpanningForest();
        return Collections.unmodifiableMap(this.spanningSuccs);
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final Collection<N> getTails() {
        if (!this.pseudoTailsCalculated) {
            IObjectDirectedGraph _graph = this.getDAG();
            HashSet<N> _dtails1 = new HashSet<N>(((AbstractDirectedGraph)((Object)_graph)).getSinks());
            HashSet _dtails2 = new HashSet();
            CollectionUtils.transform(_dtails1, ((SimpleNodeGraph)_graph).getObjectExtractor(), _dtails2);
            Collection<N> _tails = this.getSinks();
            _dtails2.removeAll(_tails);
            Collection _temp = this.getDestUnreachableSources(_dtails2, _tails, true, false);
            Collection _result = this.getDestUnreachableSources(_temp, _temp, true, false);
            if (_result.isEmpty()) {
                this.pseudoTails.addAll(_temp);
            } else {
                this.pseudoTails.addAll(_result);
            }
            this.pseudoTailsCalculated = true;
        }
        Collection _tails = SetUtils.union(this.pseudoTails, this.getSinks());
        return _tails;
    }

    @Override
    @Functional
    public final boolean hasCommonReachablesFrom(@NonNull @Immutable N node1, boolean forward1, @NonNull @Immutable N node2, boolean forward2) {
        this.calculateReachabilityInfo();
        BitSet _n1 = forward1 ? this.forwardReachabilityMatrix[this.getIndexOfNode(node1)] : this.backwardReachabilityMatrix[this.getIndexOfNode(node1)];
        BitSet _n2 = forward2 ? this.forwardReachabilityMatrix[this.getIndexOfNode(node2)] : this.backwardReachabilityMatrix[this.getIndexOfNode(node2)];
        return _n1.intersects(_n2);
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final boolean isAncestorOf(@NonNull @Immutable N ancestor, @NonNull @Immutable N descendent) {
        this.createSpanningForest();
        int _anc = this.getIndexOfNode(ancestor);
        int _desc = this.getIndexOfNode(descendent);
        return this.discoverTimes[_anc] <= this.discoverTimes[_desc] && this.finishTimes[_anc] >= this.finishTimes[_desc];
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    public final boolean isReachable(@NonNull @Immutable N src, @NonNull @Immutable N dest, boolean forward) {
        this.calculateReachabilityInfo();
        BitSet[] _matrix = forward ? this.forwardReachabilityMatrix : this.backwardReachabilityMatrix;
        return _matrix[this.getIndexOfNode(src)].get(this.getIndexOfNode(dest));
    }

    @Override
    @Functional
    @NonNull
    @NonNullContainer
    public Iterator<N> iterator() {
        return this.getNodes().iterator();
    }

    @Override
    @Functional(level=Functional.AccessSpecifier.PACKAGE)
    @NonNull
    @NonNullContainer
    public final List<N> performTopologicalSort(boolean topdown) {
        IObjectDirectedGraph _dag = this.getDAG();
        List _nodes = ((MutableDirectedGraph)((Object)_dag)).getNodes();
        TIntObjectHashMap _finishTime2node = new TIntObjectHashMap();
        HashSet _processed = new HashSet();
        int _time = 0;
        for (SimpleNode _node : _nodes) {
            if (_processed.contains(_node)) continue;
            _time = AbstractDirectedGraph.getFinishTimes(_node, _processed, _finishTime2node, _time);
        }
        int[] _keys = _finishTime2node.keys();
        ArrayList<SimpleNode> _result1 = new ArrayList<SimpleNode>(_keys.length);
        Arrays.sort(_keys);
        int _i = 0;
        while (_i < _keys.length) {
            SimpleNode _object = (SimpleNode)_finishTime2node.get(_keys[_i]);
            _result1.add(_object);
            ++_i;
        }
        if (topdown) {
            Collections.reverse(_result1);
        }
        ArrayList _result = new ArrayList();
        CollectionUtils.transform(_result1, ((SimpleNodeGraph)_dag).getObjectExtractor(), _result);
        return _result;
    }

    @Functional
    public final void setConnectivityCacheSize(@NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int size) {
        Cache<Triple<N, N, Boolean>, Collection<N>> _t = new Cache<Triple<N, N, Boolean>, Collection<N>>(size);
        _t.putAll(this.connectivityCache);
        this.connectivityCache = _t;
    }

    @Functional
    @NonNull
    public String toString() {
        StringBuffer _sb = new StringBuffer();
        List _nodes = this.getNodes();
        for (INode _node : _nodes) {
            int _nodePos = this.getIndexOfNode(_node);
            String _str = "[" + _node.toString() + "]";
            for (INode _succ : _node.getSuccsOf()) {
                _sb.append(_nodePos).append(_str).append(" -> ").append(this.getIndexOfNode(_succ)).append("[").append(_succ).append("]").append("\n");
            }
            for (INode _pred : _node.getPredsOf()) {
                _sb.append(_nodePos).append(_str).append(" <- ").append(this.getIndexOfNode(_pred)).append("[").append(_pred).append("]").append("\n");
            }
        }
        return _sb.toString();
    }

    @Functional
    protected int getIndexOfNode(@Immutable @NonNull N node) {
        return this.getNodes().indexOf(node);
    }

    protected void shapeChanged() {
        this.hasSpanningForest = false;
        this.pseudoTailsCalculated = false;
        this.reachability = false;
        this.dagExists = false;
        this.sinksAreAvailable = false;
        this.sourcesAreAvailable = false;
        this.hasSCC = false;
    }

    @NonNull
    @NonNullContainer
    @Functional
    Collection<N> calculateConnectivityNodes(@NonNull N src, @NonNull N dest, boolean forward) {
        HashSet<INode> _col = new HashSet<INode>();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(new HashSet());
        _wb.addAllWork(src.getSuccsNodesInDirection(forward));
        while (_wb.hasWork()) {
            INode _succ = (INode)_wb.getWork();
            if (this.isReachable(_succ, dest, !forward)) {
                _col.add(_succ);
                continue;
            }
            _wb.addAllWorkNoDuplicates(_succ.getSuccsNodesInDirection(forward));
        }
        return _col;
    }

    private void calculateReachabilityInfo() {
        if (!this.reachability) {
            List _nodes = this.getNodes();
            int _noOfNodes = _nodes.size();
            this.forwardReachabilityMatrix = new BitSet[_noOfNodes];
            this.backwardReachabilityMatrix = new BitSet[_noOfNodes];
            for (List<N> _scc : this.getSCCs(true)) {
                BitSet _f = new BitSet(_noOfNodes);
                BitSet _b = new BitSet(_noOfNodes);
                for (INode _node : _scc) {
                    int _iIndex = _nodes.indexOf(_node);
                    this.forwardReachabilityMatrix[_iIndex] = _f;
                    this.backwardReachabilityMatrix[_iIndex] = _b;
                }
            }
            int _iIndex = 0;
            while (_iIndex < _noOfNodes) {
                INode _node = (INode)_nodes.get(_iIndex);
                Iterator _j = _node.getSuccsOf().iterator();
                int _jEnd = _node.getSuccsOf().size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    INode _succ = (INode)_j.next();
                    int _indexOfSucc = this.getIndexOfNode(_succ);
                    this.forwardReachabilityMatrix[_iIndex].set(_indexOfSucc);
                    this.backwardReachabilityMatrix[_indexOfSucc].set(_iIndex);
                    ++_jIndex;
                }
                ++_iIndex;
            }
            int _j = 0;
            while (_j < _noOfNodes) {
                int _k = 0;
                while (_k < _noOfNodes) {
                    if (this.forwardReachabilityMatrix[_k].get(_j)) {
                        int _l = 0;
                        while (_l < _noOfNodes) {
                            if (this.forwardReachabilityMatrix[_j].get(_l)) {
                                this.forwardReachabilityMatrix[_k].set(_l);
                                this.backwardReachabilityMatrix[_l].set(_k);
                            }
                            ++_l;
                        }
                    }
                    ++_k;
                }
                ++_j;
            }
            this.reachability = true;
            int _noOfConnections = _nodes.size() * _nodes.size() / 5;
            this.connectivityCache = new Cache<Triple<N, N, Boolean>, Collection<N>>(_noOfConnections);
        }
    }

    private void createSpanningForest() {
        if (this.hasSpanningForest) {
            return;
        }
        if (this.spanningSuccs == null) {
            this.spanningSuccs = new HashMap<N, Set<N>>();
        } else {
            this.spanningSuccs.clear();
        }
        LIFOWorkBag<Object> _order = new LIFOWorkBag<Object>();
        List _nodes = this.getNodes();
        if (this.getSources().isEmpty()) {
            _order.addAllWork(_nodes);
        } else {
            _order.addAllWork(this.getSources());
        }
        ArrayList<INode> _blackNodes = new ArrayList<INode>();
        ArrayList<INode> _grayNodes = new ArrayList<INode>();
        int _discoverTime = 0;
        this.discoverTimes = new int[_nodes.size()];
        this.finishTimes = new int[_nodes.size()];
        this.backedges.clear();
        this.crossedges.clear();
        while (_order.hasWork()) {
            INode _node;
            Object _work = _order.getWork();
            if (_work instanceof Marker) {
                _node = (INode)((Marker)_work).getContent();
                int _indexOfNode = this.getIndexOfNode(_node);
                this.finishTimes[_indexOfNode] = ++_discoverTime;
                continue;
            }
            if (_blackNodes.contains(_work)) continue;
            _node = (INode)_work;
            this.discoverTimes[this.getIndexOfNode(_node)] = ++_discoverTime;
            _grayNodes.add(_node);
            _order.addWork(new Marker(_node));
            this.processNodeForSpanningTree(_grayNodes, _order, _node);
            _blackNodes.add(_node);
        }
        this.hasSpanningForest = true;
    }

    @NonNull
    @Functional
    Collection<N> getDestUnreachableSources(@NonNull @NonNullContainer @Immutable Collection<N> sourceNodes, @NonNull @NonNullContainer @Immutable Collection<N> destinations, boolean forward, boolean considerSelfReachability) {
        HashSet<N> _result = new HashSet<N>(sourceNodes);
        ArrayList<N> _temp = new ArrayList<N>(destinations);
        if (!destinations.isEmpty()) {
            Iterator<N> _i = sourceNodes.iterator();
            int _iEnd = sourceNodes.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                INode _src = (INode)_i.next();
                Collection<INode> _reachables = this.getReachablesFrom(_src, forward);
                boolean _flag = destinations.contains(_src);
                if (_flag && !considerSelfReachability) {
                    _temp.remove(_src);
                }
                if (CollectionUtils.containsAny(_reachables, _temp)) {
                    _result.remove(_src);
                }
                if (_flag && !considerSelfReachability) {
                    _temp.add(_src);
                }
                ++_iIndex;
            }
        }
        return _result;
    }

    void processNodeForSpanningTree(@NonNull @NonNullContainer @Immutable Collection<N> grayNodes, @NonNull @NonNullContainer IWorkBag<Object> workBag, @NonNull @NonNullContainer N nodeToProcess) {
        HashSet<INode> _temp = new HashSet<INode>();
        this.spanningSuccs.put(nodeToProcess, _temp);
        for (INode _succ : nodeToProcess.getSuccsOf()) {
            if (grayNodes.contains(_succ)) {
                int _destIndex = this.getIndexOfNode(_succ);
                Pair<N, INode> _edge = new Pair<N, INode>(nodeToProcess, _succ);
                if (this.finishTimes[_destIndex] > 0) {
                    this.crossedges.add(_edge);
                    continue;
                }
                this.backedges.add(_edge);
                continue;
            }
            _temp.add(_succ);
            workBag.addWork(_succ);
        }
    }
}

