/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.fa;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.fa.IAutomaton;
import edu.ksu.cis.indus.common.fa.IState;
import edu.ksu.cis.indus.common.fa.ITransitionLabel;
import edu.ksu.cis.indus.common.graph.EdgeLabelledNode;
import edu.ksu.cis.indus.common.graph.IEdgeLabel;
import edu.ksu.cis.indus.common.graph.IObjectNode;
import edu.ksu.cis.indus.common.graph.SimpleEdgeGraph;
import edu.ksu.cis.indus.common.graph.SimpleEdgeLabelledNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFA<S extends IState<S>, L extends ITransitionLabel<L>>
implements IAutomaton<S, L> {
    @NonNull
    protected final ITransitionLabel.IEpsilonLabelFactory<L> epsilonFactory;
    private S currentState;
    private final Collection<S> finalStates = new HashSet<S>();
    private final ITransformer<SimpleEdgeLabelledNode<S>, S> objectExtractor;
    private final SimpleEdgeGraph<S> seg = new SimpleEdgeGraph();
    private S startState;

    public NFA(@NonNull @Immutable ITransitionLabel.IEpsilonLabelFactory<L> eFactory) {
        this.epsilonFactory = eFactory;
        this.objectExtractor = new ITransformer<SimpleEdgeLabelledNode<S>, S>(){

            @Override
            @Functional
            public S transform(SimpleEdgeLabelledNode<S> input) {
                return (IState)input.getObject();
            }
        };
    }

    public void addFinalState(@NonNull @Immutable S state) {
        assert (state != null);
        this.seg.getNode(state);
        this.finalStates.add(state);
    }

    public void addLabelledTransitionFromTo(@NonNull @Immutable S src, @NonNull @Immutable L label, @NonNull @Immutable S dest) {
        if (this.currentState != null) {
            throw new IllegalStateException("The automata should be altered when it is not not running (prior to starting it orafter it is stopped).");
        }
        this.seg.addEdgeFromTo(this.seg.getNode(src), (IEdgeLabel)label, this.seg.getNode(dest));
    }

    @Override
    public boolean canPerformTransition(@NonNull @Immutable L label) {
        IObjectNode _node = this.seg.queryNode((Object)this.currentState);
        boolean _result = _node != null ? ((EdgeLabelledNode)((Object)_node)).hasOutgoingEdgeLabelled((IEdgeLabel)label) : false;
        return _result;
    }

    @Override
    public NFA<S, L> clone() {
        try {
            return (NFA)super.clone();
        }
        catch (CloneNotSupportedException _e) {
            throw new RuntimeException(_e);
        }
    }

    @Override
    @Functional
    public S getCurrentState() {
        return this.currentState;
    }

    @Override
    @Functional
    @NonNull
    public Collection<S> getFinalStates() {
        return this.finalStates;
    }

    @NonNull
    public Collection<S> getResultingStates(@NonNull @Immutable S state, @NonNull @Immutable L label) {
        Collection _result;
        assert (state != null && label != null);
        IObjectNode _node = this.seg.queryNode((Object)state);
        if (_node != null) {
            Collection _dests = ((EdgeLabelledNode)((Object)_node)).getSuccsViaEdgesLabelled((IEdgeLabel)label);
            _result = CollectionUtils.collect(_dests, this.objectExtractor);
        } else {
            _result = Collections.emptySet();
        }
        return _result;
    }

    @Override
    @Functional
    @NonNull
    public S getStartState() {
        return this.startState;
    }

    @Override
    @Functional
    public boolean isDeterministic() {
        return false;
    }

    @Override
    @Functional
    public boolean isInFinalState() {
        return this.finalStates.contains(this.currentState);
    }

    @Override
    public void performTransitionOn(@NonNull @Immutable L label) {
        IObjectNode _node = this.seg.queryNode((Object)this.currentState);
        if (_node == null) {
            throw new IllegalStateException("There are no transition with the label " + label + " from the current state.");
        }
        Collection _dests = ((EdgeLabelledNode)((Object)_node)).getSuccsViaEdgesLabelled((IEdgeLabel)label);
        this.currentState = (IState)((SimpleEdgeLabelledNode)_dests.iterator().next()).getObject();
    }

    public boolean removeLabelledTransitionFromTo(@NonNull @Immutable S src, @NonNull @Immutable L label, @NonNull @Immutable S dest) {
        if (this.currentState != null) {
            throw new IllegalStateException("The automata should be altered when it is not active (prior to starting it orafter it is stopped).");
        }
        return this.seg.removeEdgeFromTo(this.seg.queryNode((Object)src), (IEdgeLabel)label, this.seg.queryNode((Object)dest));
    }

    public void setStartState(@NonNull @Immutable S state) {
        assert (state != null);
        this.seg.getNode(state);
        this.startState = state;
    }

    @Override
    public void start() {
        this.currentState = this.startState;
    }

    @Override
    public void stop() {
        this.currentState = null;
    }
}

