/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.fa;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.fa.IState;
import edu.ksu.cis.indus.common.fa.ITransitionLabel;
import edu.ksu.cis.indus.common.fa.NFA;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFA<S extends IState<S>, L extends ITransitionLabel<L>>
extends NFA<S, L> {
    public DFA(@NonNull @Immutable ITransitionLabel.IEpsilonLabelFactory<L> eFactory) {
        super(eFactory);
    }

    @Override
    public void addLabelledTransitionFromTo(@NonNull @Immutable S src, @NonNull @Immutable L label, @NonNull @Immutable S dest) {
        Collection<S> _states = this.getResultingStates(src, label);
        if (!_states.isEmpty()) {
            String _msg = "A transition labelled '" + label + "' already exists from the given source (" + src + ")";
            throw new IllegalStateException(_msg);
        }
        if (label.equals(this.epsilonFactory.getEpsilonTransitionLabel())) {
            throw new IllegalArgumentException("Epsilon transitions are not allowed in Deterministic automata.");
        }
        super.addLabelledTransitionFromTo(src, label, dest);
    }

    @Override
    @Functional
    public boolean isDeterministic() {
        return true;
    }
}

