/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.datastructures.IWork;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.interfaces.IPoolable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkList<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkList.class);
    @NonNull
    @NonNullContainer
    private final IWorkBag<T> workbag;

    public WorkList(@NonNull @NonNullContainer IWorkBag<T> container) {
        this.workbag = container;
    }

    public void clear() {
        this.workbag.clear();
    }

    public int process() {
        int _result = 0;
        while (this.workbag.hasWork()) {
            T _o = this.workbag.getWork();
            if (_o instanceof IWork) {
                IWork _w = (IWork)_o;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing work:" + _w);
                }
                _w.execute();
            }
            if (_o instanceof IPoolable) {
                ((IPoolable)_o).returnToPool();
            }
            ++_result;
        }
        return _result;
    }
}

