/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Triple;
import java.util.ArrayList;

public class TripleTest
extends IndusTestCase {
    private Triple triple1;
    private Triple triple2;

    public final void testGetFirst() {
        TripleTest.assertTrue((boolean)this.triple1.getFirst().equals("first"));
    }

    public final void testGetSecond() {
        TripleTest.assertTrue((boolean)this.triple1.getSecond().equals("second"));
    }

    public final void testGetThird() {
        TripleTest.assertTrue((boolean)this.triple1.getThird().equals("third"));
    }

    public final void testHashCodeAndEquals() {
        Triple<String, String, String> _t3 = new Triple<String, String, String>("first", "second", "third");
        TripleTest.assertTrue((this.triple1.hashCode() != this.triple2.hashCode() ? 1 : 0) != 0);
        TripleTest.assertTrue((this.triple1.hashCode() == _t3.hashCode() ? 1 : 0) != 0);
        TripleTest.assertFalse((boolean)this.triple1.equals(this.triple2));
        TripleTest.assertTrue((boolean)this.triple1.equals(_t3));
        Triple<Object, Object, Object> _t4 = new Triple<Object, Object, Object>(null, null, null);
        Triple<Object, Object, Object> _t5 = new Triple<Object, Object, Object>(null, null, null);
        TripleTest.assertTrue((boolean)_t4.equals(_t5));
        TripleTest.assertTrue((_t4.hashCode() == _t5.hashCode() ? 1 : 0) != 0);
        TripleTest.assertFalse((boolean)_t4.equals("hi"));
    }

    public final void testOptimizeAndUnOptimize1() {
        ArrayList<String> _second = new ArrayList<String>();
        _second.add("first");
        Triple _t1 = new Triple("first", _second, "third");
        _t1.optimize();
        int _hash1 = _t1.hashCode();
        _second.add("second");
        TripleTest.assertTrue((_t1.hashCode() == _hash1 ? 1 : 0) != 0);
        _t1.unoptimize();
        TripleTest.assertTrue((_t1.hashCode() != _hash1 ? 1 : 0) != 0);
        _t1.optimize();
        TripleTest.assertTrue((_t1.hashCode() != _hash1 ? 1 : 0) != 0);
    }

    public final void testOptimizeAndUnOptimize2() {
        StringBuffer _second = new StringBuffer();
        _second.append("first");
        Triple<String, StringBuffer, String> _t1 = new Triple<String, StringBuffer, String>("first", _second, "third");
        int _hash1 = _t1.hashCode();
        _second.append("second");
        TripleTest.assertTrue((_t1.hashCode() == _hash1 ? 1 : 0) != 0);
        _t1.unoptimize();
        TripleTest.assertTrue((_t1.hashCode() == _hash1 ? 1 : 0) != 0);
        _t1.optimize();
        TripleTest.assertTrue((_t1.hashCode() == _hash1 ? 1 : 0) != 0);
    }

    public final void testToString() {
        StringBuffer _second = new StringBuffer();
        _second.append(true);
        Triple<String, StringBuffer, String> _t1 = new Triple<String, StringBuffer, String>("first", _second, "third");
        _t1.optimize();
        String _str1 = _t1.toString();
        _t1.unoptimize();
        _second.append(false);
        String _str2 = _t1.toString();
        TripleTest.assertFalse((boolean)_str1.equals(_str2));
        _t1.optimize();
        String _str3 = _t1.toString();
        TripleTest.assertFalse((boolean)_str1.equals(_str3));
        TripleTest.assertTrue((boolean)_str2.equals(_str3));
    }

    protected void setUp() throws Exception {
        this.triple1 = new Triple<String, String, String>("first", "second", "third");
        this.triple2 = new Triple<String, String, String>("fourth", "fifth", "sixth");
    }

    protected void tearDown() throws Exception {
        this.triple1 = null;
        this.triple2 = null;
    }
}

