/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.interfaces.IPoolable;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PoolAwareWorkBag<T>
implements IWorkBag<T> {
    private final IWorkBag<T> container;

    public PoolAwareWorkBag(@NonNull @Immutable IWorkBag<T> theContainer) {
        this.container = theContainer;
    }

    @Override
    public T getWork() {
        return this.container.getWork();
    }

    @Override
    public void addAllWork(@NonNull @Immutable Collection<? extends T> c) {
        this.container.addAllWork(c);
    }

    @Override
    @NonNull
    public Collection<T> addAllWorkNoDuplicates(@NonNull @Immutable Collection<? extends T> c) {
        Collection<T> _coll = this.container.addAllWorkNoDuplicates(c);
        for (T _o : _coll) {
            if (!(_o instanceof IPoolable)) continue;
            IPoolable _poolable = (IPoolable)_o;
            _poolable.returnToPool();
        }
        return Collections.emptyList();
    }

    @Override
    public void addWork(@NonNull @Immutable T o) {
        this.container.addWork(o);
    }

    @Override
    public boolean addWorkNoDuplicates(@NonNull @Immutable T o) {
        boolean _result = this.container.addWorkNoDuplicates(o);
        if (!_result && o instanceof IPoolable) {
            ((IPoolable)o).returnToPool();
        }
        return _result;
    }

    @Override
    public void clear() {
        this.container.clear();
    }

    @Override
    @Functional
    public boolean hasWork() {
        return this.container.hasWork();
    }
}

