/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class PairTest
extends IndusTestCase {
    private Pair pair1;
    private Pair pair2;

    public final void testGetFirst() {
        PairTest.assertTrue((boolean)this.pair1.getFirst().equals("first"));
    }

    public final void testGetSecond() {
        PairTest.assertTrue((boolean)this.pair1.getSecond().equals("second"));
    }

    public final void testHashCodeAndEquals() {
        Pair<String, String> _p3 = new Pair<String, String>("first", "second");
        PairTest.assertTrue((this.pair1.hashCode() != this.pair2.hashCode() ? 1 : 0) != 0);
        PairTest.assertTrue((this.pair1.hashCode() == _p3.hashCode() ? 1 : 0) != 0);
        PairTest.assertFalse((boolean)this.pair1.equals(this.pair2));
        PairTest.assertTrue((boolean)this.pair1.equals(_p3));
        Pair<Object, Object> _p4 = new Pair<Object, Object>(null, null);
        Pair<Object, Object> _p5 = new Pair<Object, Object>(null, null);
        PairTest.assertTrue((boolean)_p4.equals(_p5));
        PairTest.assertTrue((_p4.hashCode() == _p5.hashCode() ? 1 : 0) != 0);
        PairTest.assertFalse((boolean)_p4.equals("hi"));
    }

    public final void testMapify() {
        ArrayList _temp = new ArrayList();
        _temp.add(this.pair1);
        _temp.add(this.pair2);
        Map<Object, Collection<Object>> _map = Pair.mapify(_temp, true);
        Collection<Object> _c1 = _map.get(this.pair1.getFirst());
        PairTest.assertTrue((_c1.size() == 1 ? 1 : 0) != 0);
        PairTest.assertTrue((boolean)_c1.contains(this.pair1.getSecond()));
        Collection<Object> _c2 = _map.get(this.pair2.getFirst());
        PairTest.assertTrue((_c2.size() == 1 ? 1 : 0) != 0);
        PairTest.assertTrue((boolean)_c2.contains(this.pair2.getSecond()));
        Pair<String, String> _p1 = new Pair<String, String>("first", "fifth");
        _temp.add(_p1);
        _map = Pair.mapify(_temp, true);
        PairTest.assertTrue((boolean)(_map.get(this.pair1.getFirst()) instanceof Collection));
        PairTest.assertTrue((boolean)_map.get(this.pair1.getFirst()).contains(_p1.getSecond()));
        PairTest.assertTrue((boolean)_map.get(this.pair1.getFirst()).contains(this.pair1.getSecond()));
        _map = Pair.mapify(_temp, false);
        PairTest.assertTrue((boolean)_map.get(this.pair1.getSecond()).contains(this.pair1.getFirst()));
        PairTest.assertTrue((boolean)_map.get(_p1.getSecond()).contains(_p1.getFirst()));
        PairTest.assertTrue((boolean)_map.get(this.pair2.getSecond()).contains(this.pair2.getFirst()));
        PairTest.assertTrue((boolean)Pair.mapify(Collections.EMPTY_LIST, true).isEmpty());
    }

    public final void testOptimizeAndUnoptimize1() {
        ArrayList<String> _second = new ArrayList<String>();
        _second.add("first");
        Pair _p1 = new Pair("first", _second, true, false);
        int _hash1 = _p1.hashCode();
        _second.add("second");
        PairTest.assertTrue((_p1.hashCode() == _hash1 ? 1 : 0) != 0);
        _p1.unoptimizeHashCode();
        PairTest.assertTrue((_p1.hashCode() != _hash1 ? 1 : 0) != 0);
        _p1.optimizeHashCode();
        PairTest.assertTrue((_p1.hashCode() != _hash1 ? 1 : 0) != 0);
    }

    public final void testOptimizeAndUnoptimize2() {
        StringBuffer _second = new StringBuffer();
        _second.append("first");
        Pair<String, StringBuffer> _p1 = new Pair<String, StringBuffer>("first", _second, true, false);
        int _hash1 = _p1.hashCode();
        _second.append("second");
        PairTest.assertTrue((_p1.hashCode() == _hash1 ? 1 : 0) != 0);
        _p1.unoptimizeHashCode();
        PairTest.assertTrue((_p1.hashCode() == _hash1 ? 1 : 0) != 0);
        _p1.optimizeHashCode();
        PairTest.assertTrue((_p1.hashCode() == _hash1 ? 1 : 0) != 0);
    }

    public final void testPairManager() {
        Pair.PairManager _pmgr = new Pair.PairManager(true, true);
        Pair<String, String> _p1 = _pmgr.getPair("first", "second");
        Pair<String, String> _p2 = _pmgr.getPair("first", "second");
        Pair<String, String> _p3 = _pmgr.getPair("first", "second");
        Pair<String, String> _p4 = _pmgr.getPair("first", "second");
        PairTest.assertTrue((_p1 == _p2 ? 1 : 0) != 0);
        PairTest.assertTrue((_p3 == _p4 ? 1 : 0) != 0);
        PairTest.assertTrue((_p1 == _p3 ? 1 : 0) != 0);
        _pmgr.reset();
        Pair<String, String> _p5 = _pmgr.getPair("first", "second");
        PairTest.assertTrue((_p1 != _p5 ? 1 : 0) != 0);
    }

    public final void testToString() {
        StringBuffer _second = new StringBuffer();
        _second.append(true);
        Pair<String, StringBuffer> _p1 = new Pair<String, StringBuffer>("first", _second);
        _p1.optimizeToString();
        String _str1 = _p1.toString();
        _p1.unoptimizeToString();
        _second.append(false);
        String _str2 = _p1.toString();
        PairTest.assertFalse((boolean)_str1.equals(_str2));
        _p1.optimizeToString();
        String _str3 = _p1.toString();
        PairTest.assertFalse((boolean)_str1.equals(_str3));
        PairTest.assertTrue((boolean)_str2.equals(_str3));
    }

    protected void setUp() throws Exception {
        this.pair1 = new Pair<String, String>("first", "second");
        this.pair2 = new Pair<String, String>("third", "fourth");
    }

    protected void tearDown() throws Exception {
        this.pair1 = null;
        this.pair2 = null;
    }
}

