/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.soot.Constants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<T1, T2> {
    @Immutable
    protected final T1 first;
    @Immutable
    protected final T2 second;
    private int hashCode;
    private boolean hashOptimized;
    private String str;

    public Pair(@Immutable T1 firstParam, @Immutable T2 secondParam) {
        this.first = firstParam;
        this.second = secondParam;
    }

    public Pair(@Immutable T1 firstParam, @Immutable T2 secondParam, boolean hashcodeOptimized, boolean toStringOptimized) {
        this.first = firstParam;
        this.second = secondParam;
        if (hashcodeOptimized) {
            this.optimizeHashCode();
        }
        if (toStringOptimized) {
            this.optimizeToString();
        }
    }

    @NonNull
    @Immutable
    public static Map<Object, Collection<Object>> mapify(@Immutable @NonNull Collection<Pair<?, ?>> pairs, boolean forward) {
        Map<Object, Collection<Object>> _result = new HashMap<Object, Collection<Object>>();
        for (Pair<?, ?> _pair : pairs) {
            Object _value;
            Object _key;
            if (forward) {
                _key = _pair.getFirst();
                _value = _pair.getSecond();
            } else {
                _key = _pair.getSecond();
                _value = _pair.getFirst();
            }
            Collection<Object> _c = _result.get(_key);
            if (_c == null) {
                _c = new ArrayList<Object>();
                _result.put(_key, _c);
            }
            _c.add(_value);
        }
        if (_result.isEmpty()) {
            _result = Collections.emptyMap();
        }
        return _result;
    }

    public boolean equals(@Immutable Object o) {
        boolean _result = false;
        if (o instanceof Pair) {
            Pair _temp = (Pair)o;
            _result = this == o || (this.first == _temp.first || this.first != null && this.first.equals(_temp.first)) && (this.second == _temp.second || this.second != null && this.second.equals(_temp.second));
        }
        return _result;
    }

    @Functional
    public T1 getFirst() {
        return this.first;
    }

    @Functional
    public T2 getSecond() {
        return this.second;
    }

    public int hashCode() {
        int _result = this.hashOptimized ? this.hashCode : this.hash();
        return _result;
    }

    public void optimizeHashCode() {
        this.hashOptimized = true;
        this.hashCode = this.hash();
    }

    public void optimizeToString() {
        this.str = this.stringize();
    }

    @NonNull
    public String toString() {
        String _result = this.str == null ? this.stringize() : this.str;
        return _result;
    }

    public void unoptimizeHashCode() {
        this.hashOptimized = false;
    }

    public void unoptimizeToString() {
        this.str = null;
    }

    protected int hash() {
        int _result = 17;
        if (this.first != null) {
            _result = 37 * _result + this.first.hashCode();
        }
        if (this.second != null) {
            _result = 37 * _result + this.second.hashCode();
        }
        return _result;
    }

    @NonNull
    @Immutable
    protected String stringize() {
        return ("(" + this.first + ", " + this.second + ")").intern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PairManager {
        public static final Comparable<? extends Object> ID = "Pair management service";
        private static final IFactory<Map<Object, Pair<?, ?>>> PAIR_FACTORY = new IFactory<Map<Object, Pair<?, ?>>>(){

            @Override
            public Map<Object, Pair<?, ?>> create() {
                return new HashMap();
            }
        };
        private final boolean hashcodeOptimized;
        private final Map<Object, Map<Object, Pair<?, ?>>> pairs;
        private final boolean stringOptimized;

        public PairManager(boolean optimizeToString, boolean optimizeHashCode) {
            this.stringOptimized = optimizeToString;
            this.hashcodeOptimized = optimizeHashCode;
            this.pairs = new HashMap(Constants.getNumOfMethodsInApplication());
        }

        @NonNull
        public <T1, T2> Pair<T1, T2> getPair(@Immutable T1 firstParam, @Immutable T2 secondParam) {
            Map<Object, Pair<?, ?>> _values = MapUtils.getFromMapUsingFactory(this.pairs, secondParam, PAIR_FACTORY);
            Pair<Object, Object> _result = _values.get(firstParam);
            if (_result == null) {
                _result = new Pair<T1, T2>(firstParam, secondParam, this.hashcodeOptimized, this.stringOptimized);
                _values.put(firstParam, _result);
            }
            return _result;
        }

        public void reset() {
            this.pairs.clear();
        }
    }
}

