/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.common.datastructures.FastUnionFindElement;

public final class FastUnionFindElementTest
extends IndusTestCase {
    private FastUnionFindElement f1;
    private FastUnionFindElement f2;

    public void testFindAndUnion() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.find().equals(this.f1));
        FastUnionFindElementTest.assertTrue((boolean)this.f2.find().equals(this.f2));
        this.f1.union(this.f2);
        Object _f3 = this.f1.find();
        Object _f4 = this.f2.find();
        FastUnionFindElementTest.assertTrue((boolean)_f3.equals(_f4));
        FastUnionFindElementTest.assertTrue((_f3.equals(this.f1) || _f3.equals(this.f2) ? 1 : 0) != 0);
        FastUnionFindElement _f5 = new FastUnionFindElement();
        FastUnionFindElement _f6 = new FastUnionFindElement();
        _f5.setType("1");
        _f6.union(_f5);
        FastUnionFindElementTest.assertTrue((boolean)_f6.find().equals(_f5));
    }

    public void testGetTypeAndSetType() {
        Object _object = new Object();
        this.f1.setType(_object);
        FastUnionFindElementTest.assertTrue((boolean)_object.equals(this.f1.getType()));
        try {
            this.f1.setType(_object);
            FastUnionFindElementTest.fail((String)"This is incorrect.");
        }
        catch (IllegalStateException _e) {
            _e.printStackTrace();
        }
    }

    public void testIsAtomic() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.isAtomic());
        this.f1.addChild(this.f2);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.isAtomic());
    }

    public void testIsBound() {
        FastUnionFindElementTest.assertFalse((boolean)this.f1.isBound());
        FastUnionFindElementTest.assertFalse((boolean)this.f2.isBound());
        this.f2.union(this.f1);
        this.f1.setType(new Object());
        FastUnionFindElementTest.assertTrue((boolean)this.f1.isBound());
        FastUnionFindElementTest.assertTrue((boolean)this.f2.isBound());
    }

    public void testSameType() {
        this.f1.setType(new Object());
        Object _object = new Object();
        this.f2.setType(_object);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.sameType(this.f2));
        FastUnionFindElement _f3 = new FastUnionFindElement();
        _f3.setType(_object);
        FastUnionFindElementTest.assertTrue((boolean)this.f2.sameType(_f3));
    }

    public void testUnify1() {
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unify(this.f2));
        this.f1.union(this.f2);
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unify(this.f2));
    }

    public void testUnify2() {
        FastUnionFindElement _f3 = new FastUnionFindElement();
        FastUnionFindElement _f4 = new FastUnionFindElement();
        _f3.setType(new Object());
        _f4.setType(new Object());
        FastUnionFindElementTest.assertFalse((boolean)_f3.unify(_f4));
        this.f1.addChild(_f3);
        this.f2.addChild(_f4);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unify(this.f2));
    }

    public void testUnifyChildren() {
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unifyChildren(this.f2));
        FastUnionFindElement _f3 = new FastUnionFindElement();
        FastUnionFindElement _f4 = new FastUnionFindElement();
        this.f1.addChild(_f3);
        this.f2.addChild(_f4);
        FastUnionFindElementTest.assertTrue((boolean)this.f1.unifyChildren(this.f2));
        FastUnionFindElement _f5 = new FastUnionFindElement();
        FastUnionFindElement _f6 = new FastUnionFindElement();
        _f5.setType("1");
        _f6.setType("2");
        this.f1.addChild(_f5);
        this.f2.addChild(_f6);
        FastUnionFindElementTest.assertFalse((boolean)this.f1.unifyChildren(this.f2));
    }

    protected void setUp() throws Exception {
        this.f1 = new FastUnionFindElement();
        this.f2 = new FastUnionFindElement();
    }

    protected void tearDown() throws Exception {
        this.f1 = null;
        this.f2 = null;
    }
}

