/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastUnionFindElement<T extends FastUnionFindElement<T>> {
    protected List<T> children;
    protected T set;
    protected Object type;

    @Empty
    public FastUnionFindElement() {
    }

    public final void addChild(@NonNull @Immutable T child) {
        if (this.children == null) {
            this.children = new ArrayList<T>();
        }
        this.children.add(child);
    }

    @NonNull
    public final T find() {
        FastUnionFindElement<T> _result = this;
        while (_result.set != null) {
            _result = _result.set;
        }
        if (_result != this) {
            this.set = _result;
        }
        return (T)_result;
    }

    @Functional
    public final Object getType() {
        return ((FastUnionFindElement)this.find()).type;
    }

    @Functional
    public final boolean isAtomic() {
        return this.children == null || this.children.size() == 0;
    }

    @Functional
    public final boolean isBound() {
        return ((FastUnionFindElement)this.find()).type != null;
    }

    @Functional
    public final boolean sameType(@NonNull @Immutable T e) {
        boolean _result = false;
        if (((FastUnionFindElement)e).type != null && this.type != null) {
            _result = ((FastUnionFindElement)e).type.equals(this.type);
        }
        return _result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setType(@NonNull @Immutable Object theType) {
        if (this.set == null) {
            if (this.type != null) throw new IllegalStateException("Cannot set a type on an element with a fixed type.");
            this.type = theType;
            return;
        } else {
            ((FastUnionFindElement)this.find()).setType(theType);
        }
    }

    public final boolean unify(@NonNull T e) {
        T _b;
        boolean _result = false;
        T _a = this.find();
        if (_a == (_b = ((FastUnionFindElement)e).find()) || ((FastUnionFindElement)_a).sameType(_b)) {
            _result = true;
        } else if (!((FastUnionFindElement)_a).isAtomic() && !((FastUnionFindElement)_b).isAtomic()) {
            ((FastUnionFindElement)_a).union((FastUnionFindElement<T>)_b);
            _result = ((FastUnionFindElement)_a).unifyChildren(_b);
        } else if (!((FastUnionFindElement)_a).isBound() || !((FastUnionFindElement)_b).isBound()) {
            ((FastUnionFindElement)_a).union((FastUnionFindElement<T>)_b);
            _result = true;
        }
        return _result;
    }

    public final boolean unifyChildren(@NonNull T e) {
        boolean _result = false;
        if (this.children != null && ((FastUnionFindElement)e).children != null && this.children.size() == ((FastUnionFindElement)e).children.size()) {
            _result = true;
            int _i = this.children.size() - 1;
            while (_i >= 0 && _result) {
                FastUnionFindElement _c1 = (FastUnionFindElement)this.children.get(_i);
                FastUnionFindElement _c2 = (FastUnionFindElement)((FastUnionFindElement)e).children.get(_i);
                _result &= _c1.unify(_c2);
                --_i;
            }
        }
        return _result;
    }

    public final void union(@NonNull FastUnionFindElement<T> e) {
        T _b;
        T _a = this.find();
        if (_a != (_b = e.find())) {
            if (((FastUnionFindElement)_b).isBound()) {
                ((FastUnionFindElement)_a).set = _b;
            } else {
                ((FastUnionFindElement)_b).set = _a;
            }
        }
    }
}

