/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.datastructures;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkBag<T>
implements IWorkBag<T> {
    protected final List<T> container = new ArrayList<T>();
    private final TObjectIntHashMap countingStructure = new TObjectIntHashMap();

    @Override
    public final T getWork() {
        if (this.container.isEmpty()) {
            throw new IllegalStateException("The workbag is empty.");
        }
        T _result = this.container.remove(0);
        this.countingStructure.adjustValue(_result, -1);
        if (this.countingStructure.get(_result) == 0) {
            this.countingStructure.remove(_result);
        }
        return _result;
    }

    @Override
    public final void addAllWork(@NonNull @Immutable Collection<? extends T> c) {
        Iterator<T> _i = c.iterator();
        while (_i.hasNext()) {
            this.addWork(_i.next());
        }
    }

    @Override
    @NonNull
    public final Collection<T> addAllWorkNoDuplicates(@NonNull @Immutable Collection<? extends T> c) {
        ArrayList<T> _result = new ArrayList<T>();
        Iterator<T> _i = c.iterator();
        int _iEnd = c.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            T _element = _i.next();
            if (!this.countingStructure.containsKey(_element)) {
                this.addWork(_element);
            } else {
                _result.add(_element);
            }
            ++_iIndex;
        }
        return _result;
    }

    @Override
    public final boolean addWorkNoDuplicates(@Immutable T o) {
        boolean _result;
        boolean bl = _result = !this.countingStructure.containsKey(o);
        if (_result) {
            this.addWork(o);
        }
        return _result;
    }

    @Override
    public final void clear() {
        this.container.clear();
        this.countingStructure.clear();
    }

    @Override
    @Functional
    public final boolean hasWork() {
        return !this.container.isEmpty();
    }

    @Functional
    public String toString() {
        return new ToStringBuilder((Object)this).append("work pieces", this.container).toString();
    }

    protected final void updateInternal(@Immutable T o) {
        if (this.countingStructure.contains(o)) {
            this.countingStructure.increment(o);
        } else {
            this.countingStructure.put(o, 1);
        }
    }
}

