/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.ITransformer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerBasedLazyMap<K, V>
implements Map<K, V> {
    @NonNull
    private final Map<K, V> backedMap;
    @NonNull
    private final ITransformer<K, V> transformer;

    public TransformerBasedLazyMap(@NonNull Map<K, V> map, @NonNull @Immutable ITransformer<K, V> valueTransformer) {
        this.backedMap = map;
        this.transformer = valueTransformer;
    }

    @Override
    public void clear() {
        this.backedMap.clear();
    }

    @Override
    @Functional
    public boolean containsKey(Object key) {
        return true;
    }

    @Override
    @Functional
    public boolean containsValue(Object value) {
        return this.backedMap.containsValue(value);
    }

    @Override
    @Functional
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backedMap.entrySet();
    }

    @Override
    @Functional
    public boolean equals(Object o) {
        return this.backedMap.equals(o);
    }

    @Override
    public V get(@Immutable Object key) {
        Object _k = key;
        if (!this.backedMap.containsKey(key)) {
            V _t = this.transformer.transform(_k);
            this.backedMap.put(_k, _t);
            return _t;
        }
        return this.backedMap.get(_k);
    }

    @Override
    @Functional
    public int hashCode() {
        return this.backedMap.hashCode();
    }

    @Override
    @Functional
    public boolean isEmpty() {
        return this.backedMap.isEmpty();
    }

    @Override
    @Functional
    public Set<K> keySet() {
        return this.backedMap.keySet();
    }

    @Override
    @Functional
    public V put(K key, V value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Functional
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(@Immutable Object key) {
        return this.backedMap.remove(key);
    }

    @Override
    @Functional
    public int size() {
        return this.backedMap.size();
    }

    @Override
    @Functional
    public Collection<V> values() {
        return this.backedMap.values();
    }
}

