/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import java.util.ArrayList;
import java.util.EmptyStackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stack<T>
extends ArrayList<T>
implements Cloneable {
    private static final long serialVersionUID = -3292985677102986589L;
    private int top = -1;

    @Override
    public void clear() {
        super.clear();
        this.top = -1;
    }

    @Override
    @Functional
    public Stack<T> clone() {
        Stack _stack = (Stack)super.clone();
        return _stack;
    }

    @Functional
    public boolean empty() {
        return this.top == -1;
    }

    @Functional
    public T peek() {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        return (T)this.get(this.top);
    }

    public T pop() {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        Object _item = this.remove(this.top);
        --this.top;
        return (T)_item;
    }

    public T push(@NonNull @Immutable T item) {
        this.add(++this.top, item);
        return item;
    }

    @Functional
    public <T1 extends T> int search(T1 o) {
        int _i = this.top;
        while (_i >= 0) {
            if (this.get(_i).equals(o)) {
                return _i + 1;
            }
            --_i;
        }
        return -1;
    }
}

