/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetUtils {
    private SetUtils() {
    }

    @NonNull
    @Functional
    public static <T3, T1 extends T3, T2 extends T3> Set<T3> difference(@NonNull Collection<T1> col1, @NonNull Collection<T2> col2) {
        HashSet<T1> _r = new HashSet<T1>(col1);
        Iterator _i = _r.iterator();
        while (_i.hasNext()) {
            if (!col2.contains(_i.next())) continue;
            _i.remove();
        }
        return _r;
    }

    @Functional
    @NonNull
    public static <T> IFactory<Set<T>> getFactory() {
        return new IFactory<Set<T>>(){

            @Override
            public Set<T> create() {
                return new HashSet();
            }
        };
    }

    @NonNull
    @Functional
    public static <T3, T1 extends T3, T2 extends T3> Set<T3> intersection(@NonNull Collection<T1> col1, @NonNull Collection<T2> col2) {
        HashSet<T1> _result = new HashSet<T1>(CollectionUtils.maxSize(col1, col2));
        for (T1 _t : col1) {
            if (!col2.contains(_t)) continue;
            _result.add(_t);
        }
        return _result;
    }

    @NonNull
    @Functional
    public static <T3, T1 extends T3, T2 extends T3> Set<T3> union(@NonNull Collection<T1> col1, @NonNull Collection<T2> col2) {
        HashSet<Object> _r = new HashSet<Object>(CollectionUtils.maxSize(col1, col2));
        _r.addAll(col1);
        _r.addAll(col2);
        return _r;
    }
}

