/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.common.collections.RetrievableSet;
import java.util.Collections;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class RetrievableSetTestCase
extends TestCase {
    private RetrievableSet set;

    public final void testAddObject() {
        this.set.add(null);
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(null));
        RetrievableSetTestCase.assertFalse((boolean)this.set.contains("Hi"));
        this.set.add("Hi");
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(null));
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains("Hi"));
        String _string = new String("Hi");
        this.set.add(_string);
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(null));
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(_string));
        RetrievableSetTestCase.assertTrue((this.set.size() == 2 ? 1 : 0) != 0);
        RetrievableSetTestCase.assertSame((Object)"Hi", (Object)this.set.get(_string));
        RetrievableSetTestCase.assertNotSame((Object)_string, (Object)this.set.get(_string));
    }

    public final void testClear() {
        this.set.add(null);
        this.set.add("Hi");
        RetrievableSetTestCase.assertTrue((this.set.size() == 2 ? 1 : 0) != 0);
        this.set.clear();
        RetrievableSetTestCase.assertTrue((this.set.size() == 0 ? 1 : 0) != 0);
    }

    public final void testContainsObject() {
        this.set.add(null);
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(null));
        this.set.add("Hi");
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains("Hi"));
        RetrievableSetTestCase.assertTrue((boolean)this.set.contains(null));
    }

    public final void testGet() {
        this.set.add(null);
        RetrievableSetTestCase.assertNull(this.set.get(null));
        this.set.add("Hi");
        String _string = new String("Hi");
        RetrievableSetTestCase.assertEquals((Object)"Hi", (Object)this.set.get(_string));
        RetrievableSetTestCase.assertSame((Object)"Hi", (Object)this.set.get(_string));
        RetrievableSetTestCase.assertNotSame((Object)"Hi", (Object)_string);
        this.set.remove("Hi");
        try {
            this.set.get("Hi");
            RetrievableSetTestCase.fail((String)"Element was not removed.");
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public final void testRemoveObject() {
        this.set.add(null);
        this.set.add("Hi");
        RetrievableSetTestCase.assertTrue((this.set.size() == 2 ? 1 : 0) != 0);
        this.set.remove(null);
        RetrievableSetTestCase.assertFalse((boolean)this.set.contains(null));
        this.set.remove("Hi");
        RetrievableSetTestCase.assertFalse((boolean)this.set.contains("Hi"));
        RetrievableSetTestCase.assertTrue((boolean)this.set.isEmpty());
    }

    public final void testSize() {
        this.set.add(null);
        RetrievableSetTestCase.assertTrue((this.set.size() == 1 ? 1 : 0) != 0);
        this.set.add("Hi");
        RetrievableSetTestCase.assertTrue((this.set.size() == 2 ? 1 : 0) != 0);
        this.set.addAll(Collections.EMPTY_SET);
        RetrievableSetTestCase.assertTrue((this.set.size() == 2 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        this.set = new RetrievableSet();
    }

    protected void tearDown() throws Exception {
        this.set = null;
    }
}

