/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RetrievableSet<E>
extends AbstractSet<E> {
    private final Map<E, E> map = new HashMap<E, E>();

    @Override
    public boolean add(@Immutable E o) {
        boolean _result;
        boolean bl = _result = !this.map.containsKey(o);
        if (_result) {
            this.map.put(o, o);
        }
        return _result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Functional
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Functional
    public E get(E o) {
        if (!this.map.containsKey(o)) {
            throw new NoSuchElementException(o + " does not occur in this set.");
        }
        E _result = this.map.get(o);
        return _result;
    }

    @Override
    @Functional
    @NonNull
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(@Immutable Object o) {
        boolean _result = this.map.containsKey(o);
        if (_result) {
            this.map.remove(o);
        }
        return _result;
    }

    @Override
    @Functional
    public int size() {
        return this.map.size();
    }
}

