/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.ListUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapUtils {
    private MapUtils() {
    }

    @NonNull
    @Immutable
    public static <K, V, K1 extends K> Collection<V> getCollectionFromMap(@NonNull Map<K, Collection<V>> map, @Immutable K1 key) {
        return MapUtils.getFromMapUsingFactory(map, key, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <K, V, K1 extends K> Collection<V> getEmptyCollectionFromMap(@NonNull Map<K, Collection<V>> map, @Immutable K1 key) {
        return MapUtils.getFromMap(map, key, Collections.emptyList());
    }

    @NonNull
    @Immutable
    public static <K, V, K1 extends K> List<V> getEmptyListFromMap(@NonNull Map<K, List<V>> map, @Immutable K1 key) {
        return MapUtils.getFromMap(map, key, Collections.emptyList());
    }

    @NonNull
    @Immutable
    public static <K, K2, V2, K1 extends K> Map<K2, V2> getEmptyMapFromMap(@NonNull Map<K, Map<K2, V2>> map, @Immutable K1 key) {
        return MapUtils.getFromMap(map, key, Collections.emptyMap());
    }

    @NonNull
    @Immutable
    public static <K, V, K1 extends K> Set<V> getEmptySetFromMap(@NonNull Map<K, Set<V>> map, @Immutable K1 key) {
        return MapUtils.getFromMap(map, key, Collections.emptySet());
    }

    @NonNull
    @Immutable
    public static <K, V> IFactory<Map<K, V>> getFactory() {
        return new IFactory<Map<K, V>>(){

            @Override
            public Map<K, V> create() {
                return new HashMap();
            }
        };
    }

    @NonNull
    @Immutable
    public static <K, V, K1 extends K, V1 extends V> V getFromMap(@NonNull Map<K, V> map, @Immutable K1 key, @Immutable V1 defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1> T2 getFromMapUsingFactory(@NonNull Map<T1, T2> map, @NonNull @Immutable T3 key, @NonNull @Immutable IFactory<? extends T2> factory) {
        if (!map.containsKey(key)) {
            map.put(key, factory.create());
        }
        return map.get(key);
    }

    @NonNull
    @Immutable
    public static <K, V> List<V> getListFromMap(@NonNull Map<K, List<V>> map, @NonNull @Immutable K key) {
        return MapUtils.getFromMapUsingFactory(map, key, ListUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <K, K1 extends K, K2, V2> Map<K2, V2> getMapFromMap(@NonNull Map<K, Map<K2, V2>> map, @NonNull @Immutable K1 key) {
        return MapUtils.getFromMapUsingFactory(map, key, MapUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <K, V> Set<V> getSetFromMap(@NonNull Map<K, Set<V>> map, @NonNull @Immutable K key) {
        return MapUtils.getFromMapUsingFactory(map, key, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <K, V> Map<V, Set<K>> invertMap(@NonNull Map<K, V> map) {
        HashMap _result = new HashMap();
        Collection _values = map.keySet();
        Iterator _i = _values.iterator();
        int _iEnd = _values.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Object _valueInResult = _i.next();
            V _keyInResult = map.get(_valueInResult);
            if (!_result.containsKey(_keyInResult)) {
                HashSet _set = new HashSet();
                _result.put(_keyInResult, _set);
            }
            Collection _t = (Collection)_result.get(_keyInResult);
            _t.add(_valueInResult);
            ++_iIndex;
        }
        return _result;
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2> boolean putAllIntoCollectionInMap(@NonNull Map<T1, Collection<T2>> map, @Immutable T3 key, @NonNull @Immutable Collection<T4> values) {
        return MapUtils.putAllIntoCollectionInMapUsingFactory(map, key, values, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2, T5 extends Collection<T2>, T6 extends T5> boolean putAllIntoCollectionInMapUsingFactory(@NonNull Map<T1, T5> map, @Immutable T3 key, @NonNull @Immutable Collection<T4> values, @NonNull @Immutable IFactory<T6> factory) {
        Collection _temp = (Collection)map.get(key);
        if (_temp == null) {
            _temp = (Collection)factory.create();
            map.put(key, _temp);
        }
        return _temp.addAll(values);
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2> boolean putAllIntoListInMap(@NonNull Map<T1, List<T2>> map, @Immutable T3 key, @NonNull @Immutable Collection<T4> values) {
        return MapUtils.putAllIntoCollectionInMapUsingFactory(map, key, values, ListUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2> boolean putAllIntoSetInMap(@NonNull Map<T1, Set<T2>> map, @Immutable T3 key, @NonNull @Immutable Collection<T4> values) {
        return MapUtils.putAllIntoCollectionInMapUsingFactory(map, key, values, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1, T4 extends T2> boolean putIntoCollectionInMap(@NonNull Map<T1, Collection<T2>> map, @Immutable T3 key, @Immutable T4 value) {
        return MapUtils.putIntoCollectionInMapUsingFactory(map, key, value, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1, T4 extends T2, T5 extends Collection<T2>, T6 extends T5> boolean putIntoCollectionInMapUsingFactory(@NonNull Map<T1, T5> map, @Immutable T3 key, @Immutable T4 value, @NonNull @Immutable IFactory<T6> factory) {
        Collection _temp = (Collection)map.get(key);
        if (_temp == null) {
            _temp = (Collection)factory.create();
            map.put(key, _temp);
        }
        return _temp.add(value);
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2> boolean putIntoListInMap(@NonNull Map<T1, Collection<T2>> map, @Immutable T3 key, @Immutable T4 value) {
        return MapUtils.putIntoCollectionInMapUsingFactory(map, key, value, ListUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T3 extends T1, T2, T4 extends T2> boolean putIntoSetInMap(@NonNull Map<T1, Collection<T2>> map, @Immutable T3 key, @Immutable T4 value) {
        return MapUtils.putIntoCollectionInMapUsingFactory(map, key, value, SetUtils.getFactory());
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1> Collection<T2> queryCollection(@NonNull @Immutable Map<T1, ? extends Collection<T2>> map, @Immutable T3 key) {
        Collection<T2> _value = map.get(key);
        if (_value != null) {
            return _value;
        }
        return Collections.emptySet();
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1> List<T2> queryList(@NonNull @Immutable Map<T1, ? extends List<T2>> map, @Immutable T3 key) {
        List<T2> _value = map.get(key);
        if (_value != null) {
            return _value;
        }
        return Collections.emptyList();
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3, T4 extends T1> Map<T2, T3> queryMap(@NonNull @Immutable Map<T1, ? extends Map<T2, T3>> map, @Immutable T4 key) {
        Map<T2, T3> _value = map.get(key);
        if (_value != null) {
            return _value;
        }
        return Collections.emptyMap();
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1, T4 extends T2> T2 queryObject(@NonNull @Immutable Map<T1, T2> map, T3 key, @Immutable T4 defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    @NonNull
    @Immutable
    public static <T1, T2, T3 extends T1> Set<T2> querySet(@NonNull @Immutable Map<T1, ? extends Set<T2>> map, @Immutable T3 key) {
        Set<T2> _value = map.get(key);
        if (_value != null) {
            return _value;
        }
        return Collections.emptySet();
    }

    @NonNull
    @Immutable
    public static <T1, T2> String verbosePrint(@NonNull @Immutable Map<T1, T2> map) {
        StringBuilder _sb = new StringBuilder();
        for (T1 _k : map.keySet()) {
            T2 _v = map.get(_k);
            _sb.append(MapUtils.verbosePrintHelper('\t', _k, _v));
            _sb.append('\n');
        }
        return _sb.toString();
    }

    @NonNull
    @Immutable
    static <T1, T2> String verbosePrintHelper(char indent, @Immutable T1 key, @Immutable T2 value) {
        StringBuilder _sb = new StringBuilder();
        _sb.append(indent);
        _sb.append(key);
        _sb.append(" = ");
        if (value instanceof Map) {
            Map _map = (Map)value;
            _sb.append(MapUtils.verbosePrint(_map));
        } else {
            _sb.append(String.valueOf(value));
        }
        _sb.append('\n');
        return _sb.toString();
    }
}

