/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NumericalConstraint;
import edu.ksu.cis.indus.common.collections.IFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListUtils {
    private ListUtils() {
    }

    @Functional
    public static <T> void ensureSize(@NonNull List<T> list, @NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int finalSize, T defaultValue) {
        int _size = list.size();
        if (finalSize > _size) {
            int _i = finalSize - _size;
            while (_i > 0) {
                list.add(defaultValue);
                --_i;
            }
        }
    }

    @Immutable
    public static <T> T getAtIndexFromList(@NonNull List<T> list, @NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int index, @Immutable T defaultValue) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("invalid index: " + index + " < 0");
        }
        if (index >= list.size()) {
            ListUtils.ensureSize(list, index + 1, null);
            list.set(index, defaultValue);
        } else if (list.get(index) == null) {
            list.set(index, defaultValue);
        }
        return list.get(index);
    }

    @NonNull
    @Functional
    public static <T, T2 extends T> T getAtIndexFromListUsingFactory(@NonNull List<T> list, @NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int index, @NonNull IFactory<T2> factory) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("invalid index: " + index + " < 0");
        }
        if (index >= list.size()) {
            ListUtils.ensureSize(list, index + 1, null);
            list.set(index, factory.create());
        } else if (list.get(index) == null) {
            list.set(index, factory.create());
        }
        return list.get(index);
    }

    @NonNull
    @Functional
    public static <T> IFactory<List<T>> getFactory() {
        return new IFactory<List<T>>(){

            @Override
            public List<T> create() {
                return new ArrayList();
            }
        };
    }
}

