/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NumericalConstraint;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOrderedSet<E>
extends AbstractSet<E> {
    @NonNull
    final List<E> list;
    @NonNull
    private final Set<E> set;

    public ListOrderedSet() {
        this.set = new HashSet();
        this.list = new ArrayList();
    }

    public ListOrderedSet(@NonNull @Immutable Collection<E> c) {
        this.set = new HashSet<E>(c);
        this.list = new ArrayList<E>(c);
    }

    public ListOrderedSet(@NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int initialCapacity) {
        this.set = new HashSet(initialCapacity);
        this.list = new ArrayList(initialCapacity);
    }

    public ListOrderedSet(@NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) int initialCapacity, @NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE) float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public boolean add(@Immutable E o) {
        boolean _t = this.set.add(o);
        if (_t) {
            this.list.add(o);
        }
        return _t;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    @Functional
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    @Functional
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    @Functional
    public boolean equals(@NonNull @Immutable Object o) {
        if (o instanceof ListOrderedSet) {
            ListOrderedSet _t = (ListOrderedSet)o;
            return this.set.equals(_t.list) && this.list.equals(_t.list);
        }
        return false;
    }

    @Functional
    public E get(int i) throws IndexOutOfBoundsException {
        return this.list.get(i);
    }

    @Functional
    @NonNull
    public List<E> getUnmodifiableList() {
        return Collections.unmodifiableList(new AbstractList<E>(){

            @Override
            public E get(int index) {
                return ListOrderedSet.this.list.get(index);
            }

            @Override
            public int size() {
                return ListOrderedSet.this.list.size();
            }
        });
    }

    @Override
    @Functional
    public int hashCode() {
        return this.set.hashCode() + this.list.hashCode();
    }

    @Functional
    public int indexOf(E object) {
        return this.list.indexOf(object);
    }

    @Override
    @Functional
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    @Functional
    @NonNull
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Functional
    @NonNull
    public E remove(int i) throws IndexOutOfBoundsException {
        E _t = this.get(i);
        this.set.remove(_t);
        return _t;
    }

    @Override
    public boolean remove(@Immutable Object o) {
        this.list.remove(o);
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(@NonNull @Immutable Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(@NonNull @Immutable Collection<?> c) {
        this.list.retainAll(c);
        return this.set.retainAll(c);
    }

    @Override
    @Functional
    public int size() {
        return this.set.size();
    }

    @Override
    @Functional
    @NonNull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @Functional
    public <T> T[] toArray(@NonNull T[] a) {
        return this.list.toArray(a);
    }
}

