/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.IPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IteratorUtils {
    private IteratorUtils() {
    }

    @Functional
    @NonNull
    public static <T3, T1 extends T3, T2 extends T3> Iterable<T3> chainedIterable(final @NonNull @Immutable Iterable<T1> i1, final @NonNull @Immutable Iterable<T2> i2) {
        return new Iterable<T3>(){

            @Override
            public Iterator<T3> iterator() {
                return IteratorUtils.chainedIterator(i1.iterator(), i2.iterator());
            }
        };
    }

    @Functional
    @NonNull
    public static <T3, T1 extends T3, T2 extends T3> Iterator<T3> chainedIterator(@NonNull @Immutable Iterator<T1> i1, final @NonNull @Immutable Iterator<T2> i2) {
        return new Iterator<T3>(i1){
            private Iterator<? extends T3> curr;
            {
                this.curr = iterator;
            }

            @Override
            public boolean hasNext() {
                if (this.curr.hasNext()) {
                    return true;
                }
                this.curr = i2;
                return this.curr.hasNext();
            }

            @Override
            public T3 next() {
                if (this.hasNext()) {
                    return this.curr.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.curr.remove();
            }
        };
    }

    @Functional
    @NonNull
    public static <T1, T2 extends T1> Iterable<T2> filteredIterable(final @NonNull @Immutable Collection<T2> c, final @NonNull @Immutable IPredicate<T1> p) {
        return new Iterable<T2>(){

            @Override
            public Iterator<T2> iterator() {
                return IteratorUtils.filteredIterator(c.iterator(), p);
            }
        };
    }

    @Functional
    @NonNull
    public static <T1, T2 extends T1> Iterator<T2> filteredIterator(final @NonNull @Immutable Iterator<T2> i, final @NonNull @Immutable IPredicate<T1> p) {
        return new Iterator<T2>(){
            T2 nextItem;
            boolean nextItemUsed = true;

            @Override
            public boolean hasNext() {
                boolean _result = this.nextItemUsed ? this.moveToNextObject() : true;
                return _result;
            }

            @Override
            public T2 next() {
                if (this.nextItemUsed && !this.moveToNextObject()) {
                    throw new NoSuchElementException();
                }
                this.nextItemUsed = true;
                return this.nextItem;
            }

            @Override
            public void remove() {
                if (!this.nextItemUsed) {
                    throw new IllegalStateException("Either next() was not called or remove() was called successively.");
                }
                i.remove();
            }

            private boolean moveToNextObject() {
                while (i.hasNext()) {
                    Object _t = i.next();
                    if (!p.evaluate(_t)) continue;
                    this.nextItem = _t;
                    this.nextItemUsed = false;
                    return true;
                }
                return false;
            }
        };
    }

    @Functional
    @NonNull
    public static <T> List<T> toList(@NonNull @Immutable Iterable<T> i) {
        ArrayList<T> _r = new ArrayList<T>();
        for (T _t : i) {
            _r.add(_t);
        }
        return _r;
    }

    @Functional
    @NonNull
    public static <T> List<T> toList(@NonNull @Immutable Iterator<T> i) {
        ArrayList<T> _r = new ArrayList<T>();
        while (i.hasNext()) {
            _r.add(i.next());
        }
        return _r;
    }
}

