/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.ITransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeTransformer<R, O>
implements ITransformer<R, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokeTransformer.class);
    private final String name;

    public InvokeTransformer(@NonNull String methodName) {
        this.name = methodName;
    }

    @Override
    @Functional
    public O transform(@NonNull R input) {
        Class<?> _t = input.getClass();
        try {
            Method _m = _t.getMethod(this.name, null);
            Object _invoke = _m.invoke(input, null);
            return (O)_invoke;
        }
        catch (SecurityException _e) {
            LOGGER.error("Not enough permission to invoke method " + this.name + " on object " + input.toString(), (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (NoSuchMethodException _e) {
            LOGGER.error("Method with name " + this.name + " does not exist in type " + input.getClass(), (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (IllegalArgumentException _e) {
            LOGGER.error("Illegal argument to invoke method named " + this.name + " on object " + input.toString(), (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (IllegalAccessException _e) {
            LOGGER.error("Illegal access to method " + this.name + " on class " + input.getClass(), (Throwable)_e);
            throw new RuntimeException(_e);
        }
        catch (InvocationTargetException _e) {
            LOGGER.error("Error invoking method " + this.name + " on object " + input.getClass(), (Throwable)_e);
            throw new RuntimeException(_e);
        }
    }
}

