/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.collections.IFactory;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedLazyMap<K, V>
extends AbstractMap<K, V> {
    @NonNull
    private final Map<K, V> backedMap;
    @NonNull
    private final IFactory<V> factory;

    public FactoryBasedLazyMap(@NonNull @Immutable Map<K, V> map, @NonNull @Immutable IFactory<V> valueFactory) {
        this.backedMap = map;
        this.factory = valueFactory;
    }

    @Override
    @Functional
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    @Functional
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backedMap.entrySet();
    }

    @Override
    @Functional
    public boolean equals(Object o) {
        return this.backedMap.equals(o);
    }

    @Override
    @Functional
    public V get(Object key) {
        if (!this.backedMap.containsKey(key)) {
            V _c = this.factory.create();
            Object _k = key;
            this.backedMap.put(_k, _c);
            return _c;
        }
        return this.backedMap.get(key);
    }

    @Override
    @Functional
    public int hashCode() {
        return this.backedMap.hashCode();
    }

    @Override
    public V put(@Immutable K key, @Immutable V value) {
        return this.backedMap.put(key, value);
    }
}

