/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NumericalConstraint;
import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.IClosure;
import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.ITransformer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    public static final IFactory<BitSet> BITSET_FACTORY = new IFactory<BitSet>(){

        @Override
        public BitSet create() {
            return new BitSet();
        }
    };

    private CollectionUtils() {
    }

    @Immutable
    public static <T1, T2 extends T1> void addAll(@NonNull Collection<T1> col, @Immutable @NonNull Iterable<T2> i) {
        for (T2 _t : i) {
            col.add(_t);
        }
    }

    @Immutable
    public static <T1, T2 extends T1> void addAll(@NonNull Collection<T1> col, @Immutable @NonNull Iterator<T2> i) {
        while (i.hasNext()) {
            col.add(i.next());
        }
    }

    @Functional
    @NumericalConstraint(value=NumericalConstraint.NumericalValue.NON_NEGATIVE)
    public static <T1, T2 extends T1> int cardinality(T2 obj, @NonNull Collection<T1> col) {
        int _r;
        if (col instanceof Set) {
            _r = col.contains(obj) ? 1 : 0;
        } else {
            _r = 0;
            for (T1 _t : col) {
                if (_t != obj) continue;
                ++_r;
            }
        }
        return _r;
    }

    @Functional
    public static <T1, T2 extends T1> List<T2> collect(@NonNull Collection<T2> col, @NonNull IPredicate<T1> predicate) {
        ArrayList<T2> _result = new ArrayList<T2>(col.size());
        for (T2 _t : col) {
            if (!predicate.evaluate(_t)) continue;
            _result.add(_t);
        }
        return _result;
    }

    @Functional
    public static <I, TI extends I, TO, O extends TO> List<TO> collect(@NonNull Collection<TI> col, @NonNull ITransformer<I, O> transformer) {
        ArrayList _r = new ArrayList(col.size());
        CollectionUtils.transform(col, transformer, _r);
        return _r;
    }

    @Functional
    public static <T1, T2> boolean containsAny(@NonNull Collection<T1> col1, @NonNull Collection<T2> col2) {
        Collection<Object> _maxCol;
        Collection<Object> _minCol;
        if (col1.size() > col2.size()) {
            _minCol = col2;
            _maxCol = col1;
        } else {
            _minCol = col1;
            _maxCol = col2;
        }
        for (Object _t2 : _minCol) {
            if (!_maxCol.contains(_t2)) continue;
            return true;
        }
        return false;
    }

    @Functional
    public static <T1, T2 extends T1> boolean exists(@NonNull Collection<T2> col, @NonNull IPredicate<T1> predicate) {
        for (T2 _t : col) {
            if (!predicate.evaluate(_t)) continue;
            return true;
        }
        return false;
    }

    @Immutable
    public static <T1, T2 extends T1> void filter(@NonNull Collection<T2> col, @NonNull IPredicate<T1> predicate) {
        Iterator<T2> _i = col.iterator();
        while (_i.hasNext()) {
            if (predicate.evaluate(_i.next())) continue;
            _i.remove();
        }
    }

    @Functional
    public static <T1, T2 extends T1> T2 find(@NonNull Collection<T2> values, @NonNull IPredicate<T1> predicate) {
        for (T2 _t : values) {
            if (!predicate.evaluate(_t)) continue;
            return _t;
        }
        return null;
    }

    @Functional
    public static <T1, T2 extends T1> void forAllDo(@NonNull Collection<T2> col, @NonNull IClosure<T1> closure) {
        for (T2 _t : col) {
            closure.execute(_t);
        }
    }

    @Functional
    @NonNull
    public static <T> String prettyPrint(@NonNull Collection<T> collection) {
        StringBuffer _sb = new StringBuffer();
        _sb.append("-----------------------Collection: " + collection.getClass().getName() + " / " + collection.hashCode() + " [" + collection.size() + "]");
        ArrayList<T> _t = new ArrayList<T>(collection);
        Collections.sort(_t, ToStringBasedComparator.getComparator());
        Iterator _i = _t.iterator();
        int _iEnd = _t.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Object _element = _i.next();
            _sb.append("\n");
            _sb.append(_element.toString());
            ++_iIndex;
        }
        _sb.append("\n=====================================================");
        return _sb.toString();
    }

    @Immutable
    public static <I, TI extends I, TO, O extends TO> void transform(@Immutable @NonNull Collection<TI> inCol, @NonNull ITransformer<I, O> tranformer, @NonNull Collection<TO> outCol) {
        Iterator<TI> _i = inCol.iterator();
        while (_i.hasNext()) {
            outCol.add(tranformer.transform(_i.next()));
        }
    }

    @Functional
    static int maxSize(@NonNull Collection<?> col1, @NonNull Collection<?> col2) {
        return Math.max(col1.size(), col2.size());
    }
}

