/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.common.collections;

import edu.ksu.cis.indus.annotations.Functional;
import edu.ksu.cis.indus.annotations.Immutable;
import edu.ksu.cis.indus.annotations.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 4347239164041878764L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int maximumCapacity;

    public Cache(int maxCapacity, float loadFactor) {
        super(maxCapacity, loadFactor, true);
        this.maximumCapacity = maxCapacity;
    }

    public Cache(int maxCapacity) {
        super(maxCapacity, 0.75f, true);
        this.maximumCapacity = maxCapacity;
    }

    public Cache(@NonNull @Immutable Map<K, V> m, int maxCapacity) {
        this(maxCapacity);
        this.putAll(m);
    }

    @Override
    @Functional
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maximumCapacity;
    }
}

