/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus;

import edu.ksu.cis.indus.IXMLBasedTest;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.IXMLizer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractXMLBasedTest
extends XMLTestCase
implements IXMLBasedTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXMLBasedTest.class);
    protected IXMLizer xmlizer;
    protected final Map info = new HashMap();
    protected String xmlControlDir;
    protected String xmlTestDir;
    private IJimpleIDGenerator idGenerator;
    private IStmtGraphFactory stmtGraphFactory;
    private String testMethodName = "";
    private String testName = "";

    public final void setIdGenerator(IJimpleIDGenerator generator) {
        this.idGenerator = generator;
    }

    public void setName(String name) {
        this.testMethodName = name;
    }

    public String getName() {
        return this.testName;
    }

    public void setStmtGraphFactory(IStmtGraphFactory cfgFactory) {
        this.stmtGraphFactory = cfgFactory;
    }

    public void setTestName(String name) {
        this.testName = name;
        super.setName(name);
    }

    public void setXMLControlDir(String xmlInDir) {
        this.xmlControlDir = xmlInDir;
    }

    public void setXMLTestDir(String xmlInDir) {
        this.xmlTestDir = xmlInDir;
    }

    public void testXMLSimilarity() {
        String _outfileName = String.valueOf(this.xmlTestDir) + File.separator + this.getFileName();
        try {
            FileReader _current = new FileReader(new File(_outfileName));
            FileReader _previous = new FileReader(new File(String.valueOf(this.xmlControlDir) + File.separator + this.getFileName()));
            Diff _diff = new Diff((Reader)_previous, (Reader)_current);
            _diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
            boolean _verdict = _diff.similar();
            String _difference = _diff.toString();
            ((Reader)_current).close();
            ((Reader)_previous).close();
            AbstractXMLBasedTest.assertTrue((String)_difference, (boolean)_verdict);
        }
        catch (IOException _e) {
            LOGGER.error("Failed to read the xml file " + _outfileName, (Throwable)_e);
            AbstractXMLBasedTest.fail((String)_e.getMessage());
        }
        catch (SAXException _e) {
            LOGGER.error("Exception while parsing XML", (Throwable)_e);
            AbstractXMLBasedTest.fail((String)_e.getMessage());
        }
        catch (ParserConfigurationException _e) {
            LOGGER.error("XML parser configuration related exception", (Throwable)_e);
            AbstractXMLBasedTest.fail((String)_e.getMessage());
        }
    }

    protected String getFileName() {
        return this.xmlizer.getFileName(this.getName());
    }

    protected final void setUp() throws Exception {
        this.xmlizer = this.getXMLizer();
        this.xmlizer.setXmlOutputDir(this.xmlTestDir);
        this.xmlizer.setGenerator(this.idGenerator);
        this.localSetup();
        this.xmlizer.writeXML(this.info);
    }

    protected abstract IXMLizer getXMLizer();

    protected void localSetup() throws Exception {
        this.info.put(AbstractXMLizer.FILE_NAME_ID, this.getName());
        this.info.put(IStmtGraphFactory.ID, this.stmtGraphFactory);
    }

    protected void runTest() throws Throwable {
        super.setName(this.testMethodName);
        super.runTest();
        super.setName(this.testName);
    }

    protected void tearDown() throws Exception {
        this.info.clear();
        if (this.stmtGraphFactory != null) {
            this.stmtGraphFactory.reset();
            this.stmtGraphFactory = null;
        }
        this.xmlizer = null;
        super.tearDown();
    }
}

