/*
 * Decompiled with CFR 0.152.
 */
package soot.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.tagkit.ColorTag;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.LinkTag;
import soot.tagkit.PositionTag;
import soot.tagkit.SourceLineNumberTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.SourcePositionTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.util.StringTools;
import soot.xml.ColorAttribute;
import soot.xml.LinkAttribute;

public class Attribute {
    private ColorAttribute color;
    private int jimpleStartPos;
    private int jimpleEndPos;
    private int javaStartPos;
    private int javaEndPos;
    private int javaStartLn;
    private int javaEndLn;
    private int jimpleStartLn;
    private int jimpleEndLn;
    ArrayList texts;
    ArrayList links;

    public ColorAttribute color() {
        return this.color;
    }

    public void color(ColorAttribute c) {
        this.color = c;
    }

    public int jimpleStartPos() {
        return this.jimpleStartPos;
    }

    public void jimpleStartPos(int x) {
        this.jimpleStartPos = x;
    }

    public int jimpleEndPos() {
        return this.jimpleEndPos;
    }

    public void jimpleEndPos(int x) {
        this.jimpleEndPos = x;
    }

    public int javaStartPos() {
        return this.javaStartPos;
    }

    public void javaStartPos(int x) {
        this.javaStartPos = x;
    }

    public int javaEndPos() {
        return this.javaEndPos;
    }

    public void javaEndPos(int x) {
        this.javaEndPos = x;
    }

    public int jimpleStartLn() {
        return this.jimpleStartLn;
    }

    public void jimpleStartLn(int x) {
        this.jimpleStartLn = x;
    }

    public int jimpleEndLn() {
        return this.jimpleEndLn;
    }

    public void jimpleEndLn(int x) {
        this.jimpleEndLn = x;
    }

    public int javaStartLn() {
        return this.javaStartLn;
    }

    public void javaStartLn(int x) {
        this.javaStartLn = x;
    }

    public int javaEndLn() {
        return this.javaEndLn;
    }

    public void javaEndLn(int x) {
        this.javaEndLn = x;
    }

    public boolean hasColor() {
        return this.color() != null;
    }

    public void addText(String s) {
        if (this.texts == null) {
            this.texts = new ArrayList();
        }
        this.texts.add(s);
    }

    public void addLink(LinkAttribute la) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        this.links.add(la);
    }

    public void addTag(Tag t) {
        if (t instanceof LineNumberTag) {
            int lnNum = new Integer(((LineNumberTag)t).toString());
            this.javaStartLn(lnNum);
            this.javaEndLn(lnNum);
        } else if (t instanceof JimpleLineNumberTag) {
            JimpleLineNumberTag jlnTag = (JimpleLineNumberTag)t;
            this.jimpleStartLn(jlnTag.getStartLineNumber());
            this.jimpleEndLn(jlnTag.getEndLineNumber());
        } else if (t instanceof SourceLnPosTag) {
            SourceLnPosTag jlnTag = (SourceLnPosTag)t;
            this.javaStartLn(jlnTag.startLn());
            this.javaEndLn(jlnTag.endLn());
            this.javaStartPos(jlnTag.startPos());
            this.javaEndPos(jlnTag.endPos());
        } else if (t instanceof LinkTag) {
            LinkTag lt = (LinkTag)t;
            Host h = lt.getLink();
            LinkAttribute link = new LinkAttribute(lt.toString(), this.getJimpleLnOfHost(h), this.getJavaLnOfHost(h), lt.getClassName());
            this.addLink(link);
        } else if (t instanceof StringTag) {
            this.addText(this.formatForXML(((StringTag)t).toString()));
        } else if (t instanceof PositionTag) {
            PositionTag pt = (PositionTag)t;
            this.jimpleStartPos(pt.getStartOffset());
            this.jimpleEndPos(pt.getEndOffset());
        } else if (t instanceof ColorTag) {
            ColorTag ct = (ColorTag)t;
            ColorAttribute ca = new ColorAttribute(ct.getRed(), ct.getGreen(), ct.getBlue(), ct.isForeground());
            this.color(ca);
        } else if (!(t instanceof SourcePositionTag) && !(t instanceof SourceLineNumberTag)) {
            this.addText(t.toString());
        }
    }

    private String formatForXML(String in) {
        in = StringTools.replaceAll(in, "<", "&lt;");
        in = StringTools.replaceAll(in, ">", "&gt;");
        in = StringTools.replaceAll(in, "&", "&amp;");
        return in;
    }

    private int getJavaLnOfHost(Host h) {
        Iterator it = h.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (t instanceof SourceLnPosTag) {
                return ((SourceLnPosTag)t).startLn();
            }
            if (!(t instanceof LineNumberTag)) continue;
            return new Integer(((LineNumberTag)t).toString());
        }
        return 0;
    }

    private int getJimpleLnOfHost(Host h) {
        Iterator it = h.getTags().iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (!(t instanceof JimpleLineNumberTag)) continue;
            return ((JimpleLineNumberTag)t).getStartLineNumber();
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<srcPos sline=\"" + this.javaStartLn() + "\" eline=\"" + this.javaEndLn() + "\" spos=\"" + this.javaStartPos() + "\" epos=\"" + this.javaEndPos() + "\"/>");
        sb.append("<jmpPos sline=\"" + this.jimpleStartLn() + "\" eline=\"" + this.jimpleEndLn() + "\" spos=\"" + this.jimpleStartPos() + "\" epos=\"" + this.jimpleEndPos() + "\"/>");
        return sb.toString();
    }

    public void print(PrintWriter writerOut) {
        if (this.color() == null && this.texts == null && this.links == null) {
            return;
        }
        writerOut.println("<attribute>");
        writerOut.println("<srcPos sline=\"" + this.javaStartLn() + "\" eline=\"" + this.javaEndLn() + "\" spos=\"" + this.javaStartPos() + "\" epos=\"" + this.javaEndPos() + "\"/>");
        writerOut.println("<jmpPos sline=\"" + this.jimpleStartLn() + "\" eline=\"" + this.jimpleEndLn() + "\" spos=\"" + this.jimpleStartPos() + "\" epos=\"" + this.jimpleEndPos() + "\"/>");
        if (this.color() != null) {
            writerOut.println("<color r=\"" + this.color().red() + "\" g=\"" + this.color().green() + "\" b=\"" + this.color().blue() + "\" fg=\"" + this.color().fg() + "\"/>");
        }
        if (this.texts != null) {
            Iterator textsIt = this.texts.iterator();
            while (textsIt.hasNext()) {
                writerOut.println("<text>" + (String)textsIt.next() + "</text>");
            }
        }
        if (this.links != null) {
            Iterator linksIt = this.links.iterator();
            while (linksIt.hasNext()) {
                LinkAttribute la = (LinkAttribute)linksIt.next();
                writerOut.println("<link label=\"" + this.formatForXML(la.info()) + "\" jmpLink=\"" + la.jimpleLink() + "\" srcLink=\"" + la.javaLink() + "\" clssNm=\"" + la.className() + "\"/>");
            }
        }
        writerOut.println("</attribute>");
    }
}

