/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.util.MultiMap;

public class HashMultiMap
implements MultiMap {
    Map m = new HashMap(0);

    public HashMultiMap() {
    }

    public HashMultiMap(MultiMap m) {
        this.putAll(m);
    }

    public void putAll(MultiMap m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.putAll(o, m.get(o));
        }
    }

    public boolean isEmpty() {
        return this.numKeys() == 0;
    }

    public int numKeys() {
        return this.m.size();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Iterator it = this.m.values().iterator();
        while (it.hasNext()) {
            Set s = (Set)it.next();
            if (!s.contains(value)) continue;
            return true;
        }
        return false;
    }

    protected Set newSet() {
        return new HashSet(4);
    }

    private Set findSet(Object key) {
        Set s = (Set)this.m.get(key);
        if (s == null) {
            s = this.newSet();
            this.m.put(key, s);
        }
        return s;
    }

    public boolean put(Object key, Object value) {
        return this.findSet(key).add(value);
    }

    public boolean putAll(Object key, Set values) {
        return this.findSet(key).addAll(values);
    }

    public boolean remove(Object key, Object value) {
        Set s = (Set)this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean ret = s.remove(value);
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    public boolean remove(Object key) {
        return null != this.m.remove(key);
    }

    public boolean removeAll(Object key, Set values) {
        Set s = (Set)this.m.get(key);
        if (s == null) {
            return false;
        }
        boolean ret = s.removeAll(values);
        if (s.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    public Set get(Object o) {
        Set ret = (Set)this.m.get(o);
        if (ret == null) {
            ret = this.newSet();
            this.m.put(o, ret);
        }
        return ret;
    }

    public Set keySet() {
        return this.m.keySet();
    }

    public Set values() {
        HashSet ret = new HashSet(0);
        Iterator it = this.m.values().iterator();
        while (it.hasNext()) {
            Set s = (Set)it.next();
            ret.addAll(s);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm = (MultiMap)o;
        if (!((Object)this.keySet()).equals(mm.keySet())) {
            return false;
        }
        Iterator it = this.m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Set s = (Set)e.getValue();
            if (((Object)s).equals(mm.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.m).hashCode();
    }
}

