/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArraySet
extends AbstractSet {
    private static final int DEFAULT_SIZE = 8;
    private int numElements;
    private int maxElements;
    private Object[] elements;

    public ArraySet(int size) {
        this.maxElements = size;
        this.elements = new Object[size];
        this.numElements = 0;
    }

    public ArraySet() {
        this(8);
    }

    public ArraySet(Object[] elements) {
        this();
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
    }

    public final void clear() {
        this.numElements = 0;
    }

    public final boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public final boolean addElement(Object e) {
        if (e == null) {
            throw new RuntimeException("oops");
        }
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    public final boolean add(Object e) {
        if (e == null) {
            throw new RuntimeException("oops");
        }
        if (this.contains(e)) {
            return false;
        }
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    public final boolean addAll(Collection s) {
        boolean ret = false;
        if (!(s instanceof ArraySet)) {
            return super.addAll(s);
        }
        ArraySet as = (ArraySet)s;
        for (int i = 0; i < as.elements.length; ++i) {
            ret = this.add(as.elements[i]) | ret;
        }
        return ret;
    }

    public final int size() {
        return this.numElements;
    }

    public final Iterator iterator() {
        return new ArrayIterator();
    }

    private final void removeElementAt(int index) {
        if (index == this.numElements - 1) {
            --this.numElements;
            return;
        }
        System.arraycopy(this.elements, index + 1, this.elements, index, this.numElements - (index + 1));
        --this.numElements;
    }

    private final void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.numElements];
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        return array;
    }

    public final Object[] toArray(Object[] array) {
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        return array;
    }

    public final Object[] getUnderlyingArray() {
        return this.elements;
    }

    class Array {
        private final int DEFAULT_SIZE = 8;
        private int numElements = 0;
        private int maxElements = 8;
        private Object[] elements = new Object[8];

        public final void clear() {
            this.numElements = 0;
        }

        private final void doubleCapacity() {
            int newSize = this.maxElements * 2;
            Object[] newElements = new Object[newSize];
            System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
            this.elements = newElements;
            this.maxElements = newSize;
        }

        public final void addElement(Object e) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }

        public final void insertElementAt(Object e, int index) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            if (index == this.numElements) {
                this.elements[this.numElements++] = e;
                return;
            }
            System.arraycopy(this.elements, index, this.elements, index + 1, this.numElements - index);
            this.elements[index] = e;
            ++this.numElements;
        }

        public final boolean contains(Object e) {
            for (int i = 0; i < this.numElements; ++i) {
                if (!this.elements[i].equals(e)) continue;
                return true;
            }
            return false;
        }

        public final int size() {
            return this.numElements;
        }

        public final Object elementAt(int index) {
            return this.elements[index];
        }

        public final void removeElementAt(int index) {
            if (index == this.numElements - 1) {
                --this.numElements;
                return;
            }
            System.arraycopy(this.elements, index + 1, this.elements, index, this.numElements - (index + 1));
            --this.numElements;
        }
    }

    private class ArrayIterator
    implements Iterator {
        int nextIndex = 0;

        ArrayIterator() {
        }

        public final boolean hasNext() {
            return this.nextIndex < ArraySet.this.numElements;
        }

        public final Object next() throws NoSuchElementException {
            if (this.nextIndex >= ArraySet.this.numElements) {
                throw new NoSuchElementException();
            }
            return ArraySet.this.elements[this.nextIndex++];
        }

        public final void remove() throws NoSuchElementException {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            ArraySet.this.removeElementAt(this.nextIndex - 1);
            --this.nextIndex;
        }
    }
}

