/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class SimpleLocalUses
implements LocalUses {
    Map unitToUses;

    public SimpleLocalUses(UnitGraph graph, LocalDefs localDefs) {
        this(graph.getBody(), localDefs);
    }

    public SimpleLocalUses(Body body, LocalDefs localDefs) {
        Unit s;
        if (Options.v().time()) {
            Timers.v().usesTimer.start();
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Constructing SimpleLocalUses...");
        }
        PatchingChain units = body.getUnits();
        this.unitToUses = new HashMap(units.size() * 2 + 1, 0.7f);
        Iterator it = units.iterator();
        while (it.hasNext()) {
            s = (Unit)it.next();
            this.unitToUses.put(s, new ArrayList());
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.start();
        }
        it = units.iterator();
        while (it.hasNext()) {
            s = (Unit)it.next();
            Iterator boxIt = s.getUseBoxes().iterator();
            while (boxIt.hasNext()) {
                ValueBox useBox = (ValueBox)boxIt.next();
                if (!(useBox.getValue() instanceof Local)) continue;
                Local l = (Local)useBox.getValue();
                List possibleDefs = localDefs.getDefsOfAt(l, s);
                Iterator defIt = possibleDefs.iterator();
                while (defIt.hasNext()) {
                    List useList = (List)this.unitToUses.get(defIt.next());
                    useList.add(new UnitValueBoxPair(s, useBox));
                }
            }
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.start();
        }
        it = units.iterator();
        while (it.hasNext()) {
            s = (Unit)it.next();
            this.unitToUses.put(s, Collections.unmodifiableList((List)this.unitToUses.get(s)));
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usesTimer.end();
        }
    }

    public List getUsesOf(Unit s) {
        List l = (List)this.unitToUses.get(s);
        return l;
    }
}

