/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class LocalSplitter
extends BodyTransformer {
    public LocalSplitter(Singletons.Global g) {
    }

    public static LocalSplitter v() {
        return G.v().LocalSplitter();
    }

    protected void internalTransform(Body body, String phaseName, Map options) {
        PatchingChain units = body.getUnits();
        ArrayList webs = new ArrayList();
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Splitting locals...");
        }
        HashMap boxToSet = new HashMap(units.size() * 2 + 1, 0.7f);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.start();
        }
        CompleteUnitGraph graph = new CompleteUnitGraph(body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(graph);
        SimpleLocalUses localUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.start();
        }
        HashSet<ValueBox> markedBoxes = new HashSet<ValueBox>();
        HashMap<ValueBox, Unit> boxToUnit = new HashMap<ValueBox, Unit>(units.size() * 2 + 1, 0.7f);
        Iterator codeIt = units.iterator();
        while (codeIt.hasNext()) {
            ValueBox loBox;
            Value lo;
            Unit s = (Unit)codeIt.next();
            if (s.getDefBoxes().size() > 1) {
                throw new RuntimeException("stmt with more than 1 defbox!");
            }
            if (s.getDefBoxes().size() < 1 || !((lo = (loBox = (ValueBox)s.getDefBoxes().get(0)).getValue()) instanceof Local) || markedBoxes.contains(loBox)) continue;
            LinkedList<Unit> defsToVisit = new LinkedList<Unit>();
            LinkedList<ValueBox> boxesToVisit = new LinkedList<ValueBox>();
            ArrayList web = new ArrayList();
            webs.add(web);
            defsToVisit.add(s);
            markedBoxes.add(loBox);
            while (!boxesToVisit.isEmpty() || !defsToVisit.isEmpty()) {
                if (!defsToVisit.isEmpty()) {
                    Unit d = (Unit)defsToVisit.removeFirst();
                    web.add(d.getDefBoxes().get(0));
                    List uses = localUses.getUsesOf(d);
                    Iterator useIt = uses.iterator();
                    while (useIt.hasNext()) {
                        UnitValueBoxPair use = (UnitValueBoxPair)useIt.next();
                        if (markedBoxes.contains(use.valueBox)) continue;
                        markedBoxes.add(use.valueBox);
                        boxesToVisit.addLast(use.valueBox);
                        boxToUnit.put(use.valueBox, use.unit);
                    }
                    continue;
                }
                ValueBox box = (ValueBox)boxesToVisit.removeFirst();
                web.add(box);
                List defs = localDefs.getDefsOfAt((Local)box.getValue(), (Unit)boxToUnit.get(box));
                Iterator defIt = defs.iterator();
                while (defIt.hasNext()) {
                    Unit u = (Unit)defIt.next();
                    Iterator defBoxesIter = u.getDefBoxes().iterator();
                    while (defBoxesIter.hasNext()) {
                        ValueBox b = (ValueBox)defBoxesIter.next();
                        if (markedBoxes.contains(b)) continue;
                        markedBoxes.add(b);
                        defsToVisit.addLast(u);
                    }
                }
            }
        }
        HashMap<Local, Integer> localToUseCount = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        Iterator webIt = webs.iterator();
        while (webIt.hasNext()) {
            List web = (List)webIt.next();
            ValueBox rep = (ValueBox)web.get(0);
            Local desiredLocal = (Local)rep.getValue();
            if (!localToUseCount.containsKey(desiredLocal)) {
                localToUseCount.put(desiredLocal, new Integer(1));
                continue;
            }
            int useCount = (Integer)localToUseCount.get(desiredLocal) + 1;
            localToUseCount.put(desiredLocal, new Integer(useCount));
            Local local = (Local)desiredLocal.clone();
            local.setName(desiredLocal.getName() + "#" + useCount);
            body.getLocals().add(local);
            Iterator j = web.iterator();
            while (j.hasNext()) {
                ValueBox box = (ValueBox)j.next();
                box.setValue(local);
            }
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.end();
        }
    }
}

