/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Timers;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class ForwardFlowAnalysis
extends FlowAnalysis {
    public ForwardFlowAnalysis(DirectedGraph graph) {
        super(graph);
    }

    protected boolean isForward() {
        return true;
    }

    protected void doAnalysis() {
        Object s;
        LinkedList changedUnits = new LinkedList();
        HashSet changedUnitsSet = new HashSet();
        int numNodes = this.graph.size();
        int numComputations = 0;
        Iterator it = this.graph.iterator();
        while (it.hasNext()) {
            s = it.next();
            changedUnits.addLast(s);
            changedUnitsSet.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        it = this.graph.getHeads().iterator();
        while (it.hasNext()) {
            s = it.next();
            this.unitToBeforeFlow.put(s, this.entryInitialFlow());
        }
        Object previousAfterFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            Object s2 = changedUnits.removeFirst();
            changedUnitsSet.remove(s2);
            this.copy(this.unitToAfterFlow.get(s2), previousAfterFlow);
            List preds = this.graph.getPredsOf(s2);
            Object beforeFlow = this.unitToBeforeFlow.get(s2);
            if (preds.size() == 1) {
                this.copy(this.unitToAfterFlow.get(preds.get(0)), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(this.unitToAfterFlow.get(predIt.next()), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = this.unitToAfterFlow.get(predIt.next());
                    this.merge(beforeFlow, otherBranchFlow, beforeFlow);
                }
            }
            Object afterFlow = this.unitToAfterFlow.get(s2);
            this.flowThrough(beforeFlow, s2, afterFlow);
            ++numComputations;
            if (afterFlow.equals(previousAfterFlow)) continue;
            Iterator succIt = this.graph.getSuccsOf(s2).iterator();
            while (succIt.hasNext()) {
                Object succ = succIt.next();
                if (changedUnitsSet.contains(succ)) continue;
                changedUnits.addLast(succ);
                changedUnitsSet.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

