/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.util.StationaryArrayList;

public class StronglyConnectedComponents {
    private HashMap nodeToColor;
    private static final Object Visited = new Object();
    private static final Object Black = new Object();
    private LinkedList finishingOrder;
    private List componentList = new ArrayList();
    private HashMap nodeToComponent = new HashMap();
    MutableDirectedGraph sccGraph = new HashMutableDirectedGraph();
    private int[] indexStack;
    private Object[] nodeStack;
    private int last;

    public StronglyConnectedComponents(DirectedGraph g) {
        Object s;
        this.nodeToColor = new HashMap(3 * g.size() / 2, 0.7f);
        this.indexStack = new int[g.size()];
        this.nodeStack = new Object[g.size()];
        this.finishingOrder = new LinkedList();
        Iterator nodeIt = g.iterator();
        while (nodeIt.hasNext()) {
            s = nodeIt.next();
            if (this.nodeToColor.get(s) != null) continue;
            this.visitNode(g, s);
        }
        this.nodeToColor = new HashMap(3 * g.size(), 0.7f);
        Iterator revNodeIt = this.finishingOrder.iterator();
        while (revNodeIt.hasNext()) {
            s = revNodeIt.next();
            if (this.nodeToColor.get(s) != null) continue;
            StationaryArrayList currentComponent = null;
            currentComponent = new StationaryArrayList();
            this.nodeToComponent.put(s, currentComponent);
            this.sccGraph.addNode(currentComponent);
            this.componentList.add(currentComponent);
            this.visitRevNode(g, s, currentComponent);
        }
        this.componentList = Collections.unmodifiableList(this.componentList);
        if (Options.v().verbose()) {
            G.v().out.println("Done computing scc components");
            G.v().out.println("number of nodes in underlying graph: " + g.size());
            G.v().out.println("number of components: " + this.sccGraph.size());
        }
    }

    private void visitNode(DirectedGraph graph, Object startNode) {
        this.last = 0;
        this.nodeToColor.put(startNode, Visited);
        this.nodeStack[this.last] = startNode;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            Object toVisitNode = this.nodeStack[this.last - 1];
            if (toVisitIndex >= graph.getSuccsOf(toVisitNode).size()) {
                this.finishingOrder.addFirst(toVisitNode);
                --this.last;
                continue;
            }
            Object childNode = graph.getSuccsOf(toVisitNode).get(toVisitIndex);
            if (this.nodeToColor.get(childNode) != null) continue;
            this.nodeToColor.put(childNode, Visited);
            this.nodeStack[this.last] = childNode;
            this.indexStack[this.last++] = -1;
        }
    }

    private void visitRevNode(DirectedGraph graph, Object startNode, List currentComponent) {
        this.last = 0;
        this.nodeToColor.put(startNode, Visited);
        this.nodeStack[this.last] = startNode;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            Object toVisitNode = this.nodeStack[this.last - 1];
            if (toVisitIndex >= graph.getPredsOf(toVisitNode).size()) {
                currentComponent.add(toVisitNode);
                this.nodeToComponent.put(toVisitNode, currentComponent);
                this.nodeToColor.put(toVisitNode, Black);
                --this.last;
                continue;
            }
            Object childNode = graph.getPredsOf(toVisitNode).get(toVisitIndex);
            if (this.nodeToColor.get(childNode) == null) {
                this.nodeToColor.put(childNode, Visited);
                this.nodeStack[this.last] = childNode;
                this.indexStack[this.last++] = -1;
                continue;
            }
            if (this.nodeToColor.get(childNode) != Black || this.nodeToComponent.get(childNode) == currentComponent) continue;
            this.sccGraph.addEdge(this.nodeToComponent.get(childNode), currentComponent);
        }
    }

    public boolean equivalent(Object a, Object b) {
        return this.nodeToComponent.get(a) == this.nodeToComponent.get(b);
    }

    public List getComponents() {
        return this.componentList;
    }

    public List getComponentOf(Object a) {
        return (List)this.nodeToComponent.get(a);
    }

    public DirectedGraph getSuperGraph() {
        return this.sccGraph;
    }
}

