/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;

public class PseudoTopologicalOrderer {
    public static final boolean REVERSE = true;
    private Map stmtToColor;
    private static final Object GRAY = new Object();
    private LinkedList order;
    private boolean mIsReversed = false;
    private DirectedGraph graph;
    private int[] indexStack;
    private Object[] stmtStack;
    private int last;

    public PseudoTopologicalOrderer() {
    }

    public PseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public List newList(DirectedGraph g) {
        return this.computeOrder(g);
    }

    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public boolean isReverseOrder() {
        return this.mIsReversed;
    }

    LinkedList computeOrder(DirectedGraph g) {
        this.stmtToColor = new HashMap(3 * g.size() / 2, 0.7f);
        this.indexStack = new int[g.size()];
        this.stmtStack = new Object[g.size()];
        this.order = new LinkedList();
        this.graph = g;
        Iterator stmtIt = g.iterator();
        while (stmtIt.hasNext()) {
            Object s = stmtIt.next();
            if (this.stmtToColor.get(s) != null) continue;
            this.visitNode(s);
        }
        this.indexStack = null;
        this.stmtStack = null;
        this.stmtToColor = null;
        return this.order;
    }

    private void visitNode(Object startStmt) {
        this.last = 0;
        this.stmtToColor.put(startStmt, GRAY);
        this.stmtStack[this.last] = startStmt;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            Object toVisitNode = this.stmtStack[this.last - 1];
            if (toVisitIndex >= this.graph.getSuccsOf(toVisitNode).size()) {
                if (this.mIsReversed) {
                    this.order.addLast(toVisitNode);
                } else {
                    this.order.addFirst(toVisitNode);
                }
                --this.last;
                continue;
            }
            Object childNode = this.graph.getSuccsOf(toVisitNode).get(toVisitIndex);
            if (this.stmtToColor.get(childNode) != null) continue;
            this.stmtToColor.put(childNode, GRAY);
            this.stmtStack[this.last] = childNode;
            this.indexStack[this.last++] = -1;
        }
    }
}

