/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.util.Chain;
import soot.util.HashChain;

public class HashMutableDirectedGraph
implements MutableDirectedGraph {
    protected HashMap nodeToPreds = new HashMap();
    protected HashMap nodeToSuccs = new HashMap();
    protected Chain heads = new HashChain();
    protected Chain tails = new HashChain();

    public void clearAll() {
        this.nodeToPreds = new HashMap();
        this.nodeToSuccs = new HashMap();
        this.heads = new HashChain();
        this.tails = new HashChain();
    }

    public Object clone() {
        HashMutableDirectedGraph g = new HashMutableDirectedGraph();
        g.nodeToPreds = (HashMap)this.nodeToPreds.clone();
        g.nodeToSuccs = (HashMap)this.nodeToSuccs.clone();
        g.heads = HashChain.listToHashChain(HashChain.toList(this.heads));
        g.tails = HashChain.listToHashChain(HashChain.toList(this.tails));
        return g;
    }

    public List getHeads() {
        ArrayList l = new ArrayList();
        l.addAll(this.heads);
        return Collections.unmodifiableList(l);
    }

    public List getTails() {
        ArrayList l = new ArrayList();
        l.addAll(this.tails);
        return Collections.unmodifiableList(l);
    }

    public List getPredsOf(Object s) {
        List l = (List)this.nodeToPreds.get(s);
        if (l != null) {
            return Collections.unmodifiableList(l);
        }
        throw new RuntimeException(s + "not in graph!");
    }

    public List getSuccsOf(Object s) {
        List l = (List)this.nodeToSuccs.get(s);
        if (l != null) {
            return Collections.unmodifiableList(l);
        }
        throw new RuntimeException(s + "not in graph!");
    }

    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    public Iterator iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    public void addEdge(Object from, Object to) {
        if (from == null || to == null) {
            throw new RuntimeException("edge from or to null");
        }
        if (this.containsEdge(from, to)) {
            return;
        }
        List succsList = (List)this.nodeToSuccs.get(from);
        if (succsList == null) {
            throw new RuntimeException(from + " not in graph!");
        }
        List predsList = (List)this.nodeToPreds.get(to);
        if (predsList == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        if (this.heads.contains(to)) {
            this.heads.remove(to);
        }
        if (this.tails.contains(from)) {
            this.tails.remove(from);
        }
        succsList.add(to);
        predsList.add(from);
    }

    public void removeEdge(Object from, Object to) {
        if (!this.containsEdge(from, to)) {
            return;
        }
        List succsList = (List)this.nodeToSuccs.get(from);
        if (succsList == null) {
            throw new RuntimeException(from + " not in graph!");
        }
        List predsList = (List)this.nodeToPreds.get(to);
        if (predsList == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        succsList.remove(to);
        predsList.remove(from);
        if (succsList.isEmpty()) {
            this.tails.add(from);
        }
        if (predsList.isEmpty()) {
            this.heads.add(to);
        }
    }

    public boolean containsEdge(Object from, Object to) {
        List succs = (List)this.nodeToSuccs.get(from);
        if (succs == null) {
            return false;
        }
        return succs.contains(to);
    }

    public boolean containsNode(Object node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    public List getNodes() {
        return Arrays.asList(this.nodeToPreds.keySet().toArray());
    }

    public void addNode(Object node) {
        if (this.containsNode(node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new ArrayList());
        this.nodeToPreds.put(node, new ArrayList());
        this.heads.add(node);
        this.tails.add(node);
    }

    public void removeNode(Object node) {
        List succs = (List)((ArrayList)this.nodeToSuccs.get(node)).clone();
        Iterator succsIt = succs.iterator();
        while (succsIt.hasNext()) {
            this.removeEdge(node, succsIt.next());
        }
        this.nodeToSuccs.remove(node);
        List preds = (List)((ArrayList)this.nodeToPreds.get(node)).clone();
        Iterator predsIt = preds.iterator();
        while (predsIt.hasNext()) {
            this.removeEdge(predsIt.next(), node);
        }
        this.nodeToPreds.remove(node);
        if (this.heads.contains(node)) {
            this.heads.remove(node);
        }
        if (this.tails.contains(node)) {
            this.tails.remove(node);
        }
    }

    public void printGraph() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            G.v().out.println("Node = " + node);
            G.v().out.println("Preds:");
            Iterator predsIt = this.getPredsOf(node).iterator();
            while (predsIt.hasNext()) {
                G.v().out.print("     ");
                G.v().out.println(predsIt.next());
            }
            G.v().out.println("Succs:");
            Iterator succsIt = this.getSuccsOf(node).iterator();
            while (succsIt.hasNext()) {
                G.v().out.print("     ");
                G.v().out.println(succsIt.next());
            }
        }
    }
}

