/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.PatchingChain;
import soot.Unit;
import soot.toolkits.graph.BlockGraph;

public class Block {
    private Unit mHead;
    private Unit mTail;
    private Body mBody;
    private List mPreds;
    private List mSuccessors;
    private int mPredCount = 0;
    private int mBlockLength = 0;
    private int mIndexInMethod = 0;
    private BlockGraph mBlockGraph;
    Map allMapToUnnamed = new AllMapTo("???");

    public Block(Unit aHead, Unit aTail, Body aBody, int aIndexInMethod, int aBlockLength, BlockGraph aBlockGraph) {
        this.mHead = aHead;
        this.mTail = aTail;
        this.mBody = aBody;
        this.mIndexInMethod = aIndexInMethod;
        this.mBlockLength = aBlockLength;
        this.mBlockGraph = aBlockGraph;
    }

    public Body getBody() {
        return this.mBody;
    }

    public Iterator iterator() {
        if (this.mBody != null) {
            PatchingChain units = this.mBody.getUnits();
            return units.iterator(this.mHead, this.mTail);
        }
        return null;
    }

    public void insertBefore(Unit toInsert, Unit point) {
        if (point == this.mHead) {
            this.mHead = toInsert;
        }
        PatchingChain methodBody = this.mBody.getUnits();
        methodBody.insertBefore(toInsert, (Object)point);
    }

    public void insertAfter(Unit toInsert, Unit point) {
        if (point == this.mTail) {
            this.mTail = toInsert;
        }
        PatchingChain methodBody = this.mBody.getUnits();
        methodBody.insertAfter(toInsert, (Object)point);
    }

    public boolean remove(Unit item) {
        PatchingChain methodBody = this.mBody.getUnits();
        if (item == this.mHead) {
            this.mHead = (Unit)methodBody.getSuccOf(item);
        } else if (item == this.mTail) {
            this.mTail = (Unit)methodBody.getPredOf(item);
        }
        return methodBody.remove(item);
    }

    public Unit getSuccOf(Unit aItem) {
        PatchingChain methodBody = this.mBody.getUnits();
        if (aItem != this.mTail) {
            return (Unit)methodBody.getSuccOf(aItem);
        }
        return null;
    }

    public Unit getPredOf(Unit aItem) {
        PatchingChain methodBody = this.mBody.getUnits();
        if (aItem != this.mHead) {
            return (Unit)methodBody.getPredOf(aItem);
        }
        return null;
    }

    public void setIndexInMethod(int aIndexInMethod) {
        this.mIndexInMethod = aIndexInMethod;
    }

    public int getIndexInMethod() {
        return this.mIndexInMethod;
    }

    public Unit getHead() {
        return this.mHead;
    }

    public Unit getTail() {
        return this.mTail;
    }

    public void setPreds(List preds) {
        this.mPreds = preds;
    }

    public List getPreds() {
        return this.mPreds;
    }

    public void setSuccs(List succs) {
        this.mSuccessors = succs;
    }

    public List getSuccs() {
        return this.mSuccessors;
    }

    private Map buildMapForBlock() {
        HashMap<Unit, String> m = new HashMap<Unit, String>();
        List basicBlocks = this.mBlockGraph.getBlocks();
        Iterator it = basicBlocks.iterator();
        while (it.hasNext()) {
            Block currentBlock = (Block)it.next();
            m.put(currentBlock.getHead(), "block" + new Integer(currentBlock.getIndexInMethod()).toString());
        }
        return m;
    }

    public String toShortString() {
        return "Block #" + this.mIndexInMethod;
    }

    public String toString() {
        Iterator it;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("Block " + this.mIndexInMethod + ":" + System.getProperty("line.separator"));
        strBuf.append("[preds: ");
        boolean count = false;
        if (this.mPreds != null) {
            it = this.mPreds.iterator();
            while (it.hasNext()) {
                strBuf.append(((Block)it.next()).getIndexInMethod() + " ");
            }
        }
        strBuf.append("] [succs: ");
        if (this.mSuccessors != null) {
            it = this.mSuccessors.iterator();
            while (it.hasNext()) {
                strBuf.append(((Block)it.next()).getIndexInMethod() + " ");
            }
        }
        strBuf.append("]" + System.getProperty("line.separator"));
        PatchingChain methodUnits = this.mBody.getUnits();
        Iterator basicBlockIt = methodUnits.iterator(this.mHead, this.mTail);
        if (basicBlockIt.hasNext()) {
            Unit someUnit = (Unit)basicBlockIt.next();
            strBuf.append(someUnit.toString() + ";" + System.getProperty("line.separator"));
            while (basicBlockIt.hasNext() && (someUnit = (Unit)basicBlockIt.next()) != this.mTail) {
                strBuf.append(someUnit.toString() + ";" + System.getProperty("line.separator"));
            }
            someUnit = this.mTail;
            if (this.mTail == null) {
                strBuf.append("error: null tail found; block length: " + this.mBlockLength + "" + System.getProperty("line.separator"));
            } else if (this.mHead != this.mTail) {
                strBuf.append(someUnit.toString() + ";" + System.getProperty("line.separator"));
            }
        } else {
            G.v().out.println("No basic blocks found; must be interface class.");
        }
        return strBuf.toString();
    }

    class AllMapTo
    extends AbstractMap {
        Object dest;

        public AllMapTo(Object dest) {
            this.dest = dest;
        }

        public Object get(Object key) {
            return this.dest;
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

