/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.io.UnsupportedEncodingException;
import soot.tagkit.Tag;

public class InnerClassTag
implements Tag {
    String innerClass;
    String outerClass;
    String name;
    int accessFlags;

    public InnerClassTag(String innerClass, String outerClass, String name, int accessFlags) {
        this.innerClass = innerClass;
        this.outerClass = outerClass;
        this.name = name;
        this.accessFlags = accessFlags;
    }

    public String getName() {
        return "InnerClassTag";
    }

    public byte[] getValue() {
        try {
            return this.innerClass.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public String getInnerClass() {
        return this.innerClass;
    }

    public String getOuterClass() {
        return this.outerClass;
    }

    public String getShortName() {
        return this.name;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String toString() {
        return "[inner=" + this.innerClass + ", outer=" + this.outerClass + ", name=" + this.name + ",flags=" + this.accessFlags + "]";
    }
}

