/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.tagkit.Host;
import soot.tagkit.Tag;

public class AbstractHost
implements Host {
    private static final List emptyList = Collections.EMPTY_LIST;
    private List mTagList = emptyList;

    public List getTags() {
        return this.mTagList;
    }

    public void removeTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            this.mTagList.remove(tagIndex);
        }
    }

    private int searchForTag(String aName) {
        int i = 0;
        Iterator it = this.mTagList.iterator();
        while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            if (tag.getName().equals(aName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Tag getTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            return (Tag)this.mTagList.get(tagIndex);
        }
        return null;
    }

    public boolean hasTag(String aName) {
        return this.searchForTag(aName) != -1;
    }

    public void addTag(Tag t) {
        if (this.mTagList == emptyList) {
            this.mTagList = new ArrayList(1);
        }
        this.mTagList.add(t);
    }

    public void removeAllTags() {
        this.mTagList = emptyList;
    }

    public void addAllTagsOf(Host h) {
        Iterator tIt = h.getTags().iterator();
        while (tIt.hasNext()) {
            Tag t = (Tag)tIt.next();
            this.addTag(t);
        }
    }
}

