/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.shimple.internal.analysis.DominatorTree;
import soot.toolkits.graph.Block;

public class DominatorNode {
    private Block block;
    private DominatorNode parent;
    private List children;
    private DominatorTree dominatorTree;
    private boolean frontierKnown;
    private List dominanceFrontier;

    public DominatorNode(Block block) {
        this.block = block;
        this.children = new ArrayList();
        this.frontierKnown = false;
        this.dominanceFrontier = new ArrayList();
    }

    public void setParent(DominatorNode parent) {
        this.parent = parent;
    }

    public boolean addChild(DominatorNode child) {
        if (this.children.contains(child)) {
            return false;
        }
        this.children.add(child);
        return true;
    }

    public void setDominatorTree(DominatorTree dominatorTree) {
        this.dominatorTree = dominatorTree;
    }

    public boolean addToDominanceFrontier(DominatorNode frontierNode) {
        if (this.dominanceFrontier.contains(frontierNode)) {
            return false;
        }
        this.dominanceFrontier.add(frontierNode);
        return true;
    }

    public void setFrontierKnown() {
        this.frontierKnown = true;
    }

    public Block getBlock() {
        return this.block;
    }

    public DominatorNode getParent() {
        return this.parent;
    }

    public boolean isImmediateDominator(DominatorNode node) {
        return this.parent == node;
    }

    public List getChildren() {
        return this.children;
    }

    public List getPreds() {
        Iterator predsIt = this.block.getPreds().iterator();
        ArrayList<DominatorNode> predNodes = new ArrayList<DominatorNode>();
        while (predsIt.hasNext()) {
            Block pred = (Block)predsIt.next();
            predNodes.add(this.dominatorTree.fetchNode(pred));
        }
        return predNodes;
    }

    public List getSuccs() {
        Iterator succsIt = this.block.getSuccs().iterator();
        ArrayList<DominatorNode> succNodes = new ArrayList<DominatorNode>();
        while (succsIt.hasNext()) {
            Block succ = (Block)succsIt.next();
            succNodes.add(this.dominatorTree.fetchNode(succ));
        }
        return succNodes;
    }

    public boolean isFrontierKnown() {
        return this.frontierKnown;
    }

    public List getDominanceFrontier() {
        if (!this.frontierKnown) {
            throw new RuntimeException("Frontier not properly defined.");
        }
        return this.dominanceFrontier;
    }

    public boolean isHead() {
        return this.parent == null;
    }

    public boolean isTail() {
        return this.children.size() == 0;
    }

    public boolean dominates(DominatorNode node) {
        DominatorNode child;
        int i;
        if (this.isHead()) {
            return true;
        }
        if (this.isTail()) {
            return false;
        }
        if (this.equals(node)) {
            return true;
        }
        for (i = 0; i < this.children.size(); ++i) {
            child = (DominatorNode)this.children.get(i);
            if (!child.equals(node)) continue;
            return true;
        }
        for (i = 0; i < this.children.size(); ++i) {
            child = (DominatorNode)this.children.get(i);
            if (!child.dominates(node)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.block.toString();
    }
}

