/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeVariable;

class StronglyConnectedComponents {
    List variables;
    Set black;
    LinkedList finished;
    LinkedList forest = new LinkedList();
    LinkedList current_tree;
    private static final boolean DEBUG = false;

    public static void merge(List typeVariableList) throws TypeException {
        new StronglyConnectedComponents(typeVariableList);
    }

    private StronglyConnectedComponents(List typeVariableList) throws TypeException {
        TypeVariable var;
        this.variables = typeVariableList;
        this.black = new TreeSet();
        this.finished = new LinkedList();
        Iterator i = this.variables.iterator();
        while (i.hasNext()) {
            var = (TypeVariable)i.next();
            if (this.black.contains(var)) continue;
            this.black.add(var);
            this.dfsg_visit(var);
        }
        this.black = new TreeSet();
        i = this.finished.iterator();
        while (i.hasNext()) {
            var = (TypeVariable)i.next();
            if (this.black.contains(var)) continue;
            this.current_tree = new LinkedList();
            this.forest.add(this.current_tree);
            this.black.add(var);
            this.dfsgt_visit(var);
        }
        i = this.forest.iterator();
        while (i.hasNext()) {
            LinkedList list = (LinkedList)i.next();
            TypeVariable previous = null;
            Object s = null;
            Iterator j = list.iterator();
            while (j.hasNext()) {
                TypeVariable current = (TypeVariable)j.next();
                if (previous == null) {
                    previous = current;
                    continue;
                }
                previous = previous.union(current);
            }
        }
    }

    private void dfsg_visit(TypeVariable var) {
        List parents = var.parents();
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            TypeVariable parent = (TypeVariable)i.next();
            if (this.black.contains(parent)) continue;
            this.black.add(parent);
            this.dfsg_visit(parent);
        }
        this.finished.add(0, var);
    }

    private void dfsgt_visit(TypeVariable var) {
        this.current_tree.add(var);
        List children = var.children();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            TypeVariable child = (TypeVariable)i.next();
            if (this.black.contains(child)) continue;
            this.black.add(child);
            this.dfsgt_visit(child);
        }
    }
}

