/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.Iterator;
import java.util.Map;
import soot.EquivalentValue;
import soot.SideEffectTester;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class UpSafetyAnalysis
extends ForwardFlowAnalysis {
    private SideEffectTester sideEffect;
    private Map unitToGenerateMap;
    private BoundedFlowSet set;

    public UpSafetyAnalysis(DirectedGraph dg) {
        super(dg);
        throw new RuntimeException("Don't use this Constructor!");
    }

    public UpSafetyAnalysis(DirectedGraph dg, Map unitToGen, SideEffectTester sideEffect) {
        this(dg, unitToGen, sideEffect, new ArrayPackedSet(new CollectionFlowUniverse(unitToGen.values())));
    }

    public UpSafetyAnalysis(DirectedGraph dg, Map unitToGen, SideEffectTester sideEffect, BoundedFlowSet set) {
        super(dg);
        this.sideEffect = sideEffect;
        UnitGraph g = (UnitGraph)dg;
        this.set = set;
        this.unitToGenerateMap = unitToGen;
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        return this.set.topSet();
    }

    protected Object entryInitialFlow() {
        return this.set.emptySet();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.copy(out);
        Value add = (Value)this.unitToGenerateMap.get(unit);
        if (add != null) {
            out.add(add, out);
        }
        Unit u = (Unit)unit;
        Iterator outIt = out.iterator();
        block0: while (outIt.hasNext()) {
            EquivalentValue equiVal = (EquivalentValue)outIt.next();
            Value avail = equiVal.getValue();
            if (avail instanceof FieldRef) {
                if (!this.sideEffect.unitCanWriteTo(u, avail)) continue;
                outIt.remove();
                continue;
            }
            Iterator usesIt = avail.getUseBoxes().iterator();
            while (usesIt.hasNext()) {
                Value use = ((ValueBox)usesIt.next()).getValue();
                if (!this.sideEffect.unitCanWriteTo(u, use)) continue;
                outIt.remove();
                continue block0;
            }
        }
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

