/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.options.Options;
import soot.toolkits.graph.CompleteUnitGraph;

public class UnreachableCodeEliminator
extends BodyTransformer {
    CompleteUnitGraph stmtGraph;
    HashSet visited;
    int numPruned;

    public UnreachableCodeEliminator(Singletons.Global g) {
    }

    public static UnreachableCodeEliminator v() {
        return G.v().UnreachableCodeEliminator();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        StmtBody body = (StmtBody)b;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Eliminating unreachable code...");
        }
        this.numPruned = 0;
        this.stmtGraph = new CompleteUnitGraph(body);
        this.visited = new HashSet();
        if (!body.getUnits().isEmpty()) {
            this.visitStmts((Stmt)body.getUnits().getFirst());
        }
        Iterator stmtIt = body.getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (this.visited.contains(stmt)) continue;
            body.getUnits().remove(stmt);
            stmt.clearUnitBoxes();
            ++this.numPruned;
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Removed " + this.numPruned + " statements...");
        }
        Iterator trapIt = b.getTraps().iterator();
        while (trapIt.hasNext()) {
            Trap t = (Trap)trapIt.next();
            if (t.getBeginUnit() != t.getEndUnit()) continue;
            t.clearUnitBoxes();
            trapIt.remove();
        }
    }

    private void visitStmts(Stmt head) {
        LinkedList<Stmt> st = new LinkedList<Stmt>();
        st.addLast(head);
        while (!st.isEmpty()) {
            Object stmt = st.removeLast();
            if (this.visited.contains(stmt)) continue;
            this.visited.add(stmt);
            Iterator succIt = this.stmtGraph.getSuccsOf(stmt).iterator();
            while (succIt.hasNext()) {
                Object o = succIt.next();
                if (this.visited.contains(o)) continue;
                st.addLast((Stmt)o);
            }
        }
    }
}

