/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.AvailableExpressions;
import soot.jimple.toolkits.scalar.SlowAvailableExpressionsAnalysis;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;
import soot.util.HashChain;

public class SlowAvailableExpressions
implements AvailableExpressions {
    Map unitToPairsAfter;
    Map unitToPairsBefore;
    Map unitToEquivsAfter;
    Map unitToEquivsBefore;

    public SlowAvailableExpressions(Body b) {
        SlowAvailableExpressionsAnalysis analysis = new SlowAvailableExpressionsAnalysis(new CompleteUnitGraph(b));
        this.unitToPairsAfter = new HashMap(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToPairsBefore = new HashMap(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsAfter = new HashMap(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsBefore = new HashMap(b.getUnits().size() * 2 + 1, 0.7f);
        Iterator unitIt = b.getUnits().iterator();
        while (unitIt.hasNext()) {
            EquivalentValue ev;
            UnitValueBoxPair p;
            Stmt containingStmt;
            Value v;
            Unit s = (Unit)unitIt.next();
            FlowSet set = (FlowSet)analysis.getFlowBefore(s);
            ArrayList<UnitValueBoxPair> pairsBefore = new ArrayList<UnitValueBoxPair>();
            ArrayList<UnitValueBoxPair> pairsAfter = new ArrayList<UnitValueBoxPair>();
            HashChain equivsBefore = new HashChain();
            HashChain equivsAfter = new HashChain();
            List setAsList = set.toList();
            Iterator si = setAsList.iterator();
            while (si.hasNext()) {
                v = (Value)si.next();
                containingStmt = (Stmt)analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                ev = new EquivalentValue(v);
                pairsBefore.add(p);
                if (equivsBefore.contains(ev)) continue;
                equivsBefore.add(ev);
            }
            this.unitToPairsBefore.put(s, pairsBefore);
            this.unitToEquivsBefore.put(s, equivsBefore);
            set = (FlowSet)analysis.getFlowAfter(s);
            setAsList = set.toList();
            si = setAsList.iterator();
            while (si.hasNext()) {
                v = (Value)si.next();
                containingStmt = (Stmt)analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                ev = new EquivalentValue(v);
                pairsAfter.add(p);
                if (equivsAfter.contains(ev)) continue;
                equivsAfter.add(ev);
            }
            this.unitToPairsAfter.put(s, pairsAfter);
            this.unitToEquivsAfter.put(s, equivsAfter);
        }
    }

    public List getAvailablePairsBefore(Unit u) {
        return (List)this.unitToPairsBefore.get(u);
    }

    public List getAvailablePairsAfter(Unit u) {
        return (List)this.unitToPairsAfter.get(u);
    }

    public Chain getAvailableEquivsBefore(Unit u) {
        return (Chain)this.unitToEquivsBefore.get(u);
    }

    public Chain getAvailableEquivsAfter(Unit u) {
        return (Chain)this.unitToEquivsAfter.get(u);
    }
}

