/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.NumericConstant;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.SimpleLocalDefs;

public class ConstantPropagatorAndFolder
extends BodyTransformer {
    public ConstantPropagatorAndFolder(Singletons.Global g) {
    }

    public static ConstantPropagatorAndFolder v() {
        return G.v().ConstantPropagatorAndFolder();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        StmtBody stmtBody = (StmtBody)b;
        int numFolded = 0;
        int numPropagated = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "] Propagating and folding constants...");
        }
        PatchingChain units = stmtBody.getUnits();
        CompleteUnitGraph unitGraph = new CompleteUnitGraph(stmtBody);
        SimpleLocalDefs localDefs = new SimpleLocalDefs(unitGraph);
        Iterator stmtIt = new PseudoTopologicalOrderer().newList(unitGraph).iterator();
        while (stmtIt.hasNext()) {
            ValueBox useBox;
            Stmt stmt = (Stmt)stmtIt.next();
            Iterator useBoxIt = stmt.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                DefinitionStmt defStmt;
                Local local;
                List defsOfUse;
                useBox = (ValueBox)useBoxIt.next();
                if (!(useBox.getValue() instanceof Local) || (defsOfUse = localDefs.getDefsOfAt(local = (Local)useBox.getValue(), stmt)).size() != 1 || !((defStmt = (DefinitionStmt)defsOfUse.get(0)).getRightOp() instanceof NumericConstant) || !useBox.canContainValue(defStmt.getRightOp())) continue;
                useBox.setValue(defStmt.getRightOp());
                ++numPropagated;
            }
            useBoxIt = stmt.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                Value constValue;
                useBox = (ValueBox)useBoxIt.next();
                Value value = useBox.getValue();
                if (value instanceof Constant || !Evaluator.isValueConstantValued(value) || !useBox.canContainValue(constValue = Evaluator.getConstantValueOf(value))) continue;
                useBox.setValue(constValue);
                ++numFolded;
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "]     Propagated: " + numPropagated + ", Folded:  " + numFolded);
        }
    }
}

