/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.PointsToSet;
import soot.jimple.toolkits.pointer.Union;

public class MemoryEfficientRasUnion
extends Union {
    HashSet subsets;

    public boolean isEmpty() {
        if (this.subsets == null) {
            return true;
        }
        Iterator subsetIt = this.subsets.iterator();
        while (subsetIt.hasNext()) {
            PointsToSet subset = (PointsToSet)subsetIt.next();
            if (subset.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonEmptyIntersection(PointsToSet other) {
        if (this.subsets == null) {
            return true;
        }
        Iterator subsetIt = this.subsets.iterator();
        while (subsetIt.hasNext()) {
            PointsToSet subset = (PointsToSet)subsetIt.next();
            if (!(other instanceof Union ? other.hasNonEmptyIntersection(subset) : subset.hasNonEmptyIntersection(other))) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(PointsToSet s) {
        boolean ret = false;
        if (this.subsets == null) {
            this.subsets = new HashSet();
        }
        if (s instanceof Union) {
            MemoryEfficientRasUnion meru = (MemoryEfficientRasUnion)s;
            if (meru.subsets == null || this.subsets.containsAll(meru.subsets)) {
                return false;
            }
            return this.subsets.addAll(meru.subsets);
        }
        PointsToSet r = s;
        return this.subsets.add(s);
    }

    public Object clone() {
        MemoryEfficientRasUnion ret = new MemoryEfficientRasUnion();
        ret.addAll(this);
        return ret;
    }

    public Set possibleTypes() {
        if (this.subsets == null) {
            return Collections.EMPTY_SET;
        }
        HashSet ret = new HashSet();
        Iterator subsetIt = this.subsets.iterator();
        while (subsetIt.hasNext()) {
            PointsToSet subset = (PointsToSet)subsetIt.next();
            ret.addAll(subset.possibleTypes());
        }
        return ret;
    }
}

