/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.Iterator;
import soot.Hierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.invoke.AccessManager;

public class InlinerSafetyManager {
    public static boolean ensureInlinability(SootMethod target, Stmt toInline, SootMethod container2, String modifierOptions) {
        if (!InlinerSafetyManager.canSafelyInlineInto(target, toInline, container2)) {
            return false;
        }
        if (!AccessManager.ensureAccess(container2, target, modifierOptions)) {
            return false;
        }
        JimpleBody inlineeBody = (JimpleBody)target.getActiveBody();
        Iterator unitsIt = inlineeBody.getUnits().iterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (st.containsInvokeExpr()) {
                InvokeExpr ie1 = st.getInvokeExpr();
                if (ie1 instanceof SpecialInvokeExpr) {
                    if (InlinerSafetyManager.specialInvokePerformsLookupIn(ie1, container2.getDeclaringClass()) || InlinerSafetyManager.specialInvokePerformsLookupIn(ie1, target.getDeclaringClass())) {
                        return false;
                    }
                    SootMethod specialTarget = ie1.getMethod();
                    if (specialTarget.isPrivate() && specialTarget.getDeclaringClass() != container2.getDeclaringClass()) {
                        return false;
                    }
                }
                if (!AccessManager.ensureAccess(container2, ie1.getMethod(), modifierOptions)) {
                    return false;
                }
            }
            if (!(st instanceof AssignStmt)) continue;
            Value lhs = ((AssignStmt)st).getLeftOp();
            Value rhs = ((AssignStmt)st).getRightOp();
            if (lhs instanceof FieldRef && !AccessManager.ensureAccess(container2, ((FieldRef)lhs).getField(), modifierOptions)) {
                return false;
            }
            if (!(rhs instanceof FieldRef) || AccessManager.ensureAccess(container2, ((FieldRef)rhs).getField(), modifierOptions)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSafelyInlineInto(SootMethod inlinee, Stmt toInline, SootMethod container2) {
        Value base;
        if (inlinee.getName().equals("<init>")) {
            return false;
        }
        if (inlinee.getSignature().equals(container2.getSignature())) {
            return false;
        }
        if (inlinee.isNative() || inlinee.isAbstract()) {
            return false;
        }
        InvokeExpr ie = toInline.getInvokeExpr();
        Value value = base = ie instanceof InstanceInvokeExpr ? ((InstanceInvokeExpr)ie).getBase() : null;
        if (base != null && InlinerSafetyManager.invokeThrowsAccessErrorIn(((RefType)base.getType()).getSootClass(), inlinee, container2)) {
            return false;
        }
        return !(ie instanceof SpecialInvokeExpr) || !InlinerSafetyManager.specialInvokePerformsLookupIn(ie, inlinee.getDeclaringClass()) && !InlinerSafetyManager.specialInvokePerformsLookupIn(ie, container2.getDeclaringClass());
    }

    private static boolean invokeThrowsAccessErrorIn(SootClass base, SootMethod inlinee, SootMethod container2) {
        SootClass inlineeClass = inlinee.getDeclaringClass();
        SootClass containerClass = container2.getDeclaringClass();
        if (inlinee.isPrivate() && !inlineeClass.getName().equals(containerClass.getName())) {
            return true;
        }
        if (!(inlinee.isPrivate() || inlinee.isProtected() || inlinee.isPublic() || inlineeClass.getPackageName().equals(containerClass.getPackageName()))) {
            return true;
        }
        if (inlinee.isProtected()) {
            Hierarchy h = Scene.v().getActiveHierarchy();
            boolean saved = false;
            if (h.isClassSuperclassOfIncluding(inlineeClass, containerClass) || base != null && h.isClassSuperclassOfIncluding(base, containerClass)) {
                saved = true;
            }
            if (!saved) {
                return true;
            }
        }
        return false;
    }

    static boolean specialInvokePerformsLookupIn(InvokeExpr ie, SootClass containerClass) {
        SootMethod m = ie.getMethod();
        if (m.getName().equals("<init>")) {
            return false;
        }
        if (m.isPrivate()) {
            return false;
        }
        Hierarchy h = Scene.v().getActiveHierarchy();
        return h.isClassSuperclassOf(m.getDeclaringClass(), containerClass);
    }
}

