/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Iterator;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.util.NumberedSet;

public class TransitiveTargets {
    private CallGraph cg;
    private Filter filter;

    public TransitiveTargets(CallGraph cg) {
        this.cg = cg;
    }

    public TransitiveTargets(CallGraph cg, Filter filter) {
        this.cg = cg;
        this.filter = filter;
    }

    public Iterator iterator(Unit u) {
        ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
        Iterator it = this.cg.edgesOutOf(u);
        if (this.filter != null) {
            it = this.filter.wrap(it);
        }
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            methods.add(e.tgt());
        }
        return this.iterator(methods.iterator());
    }

    public Iterator iterator(SootMethod method) {
        ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
        Iterator it = this.cg.edgesOutOf(method);
        if (this.filter != null) {
            it = this.filter.wrap(it);
        }
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            methods.add(e.tgt());
        }
        return this.iterator(methods.iterator());
    }

    public Iterator iterator(Iterator methods) {
        NumberedSet s = new NumberedSet(Scene.v().getMethodNumberer());
        ArrayList<SootMethod> worklist = new ArrayList<SootMethod>();
        while (methods.hasNext()) {
            SootMethod method = (SootMethod)methods.next();
            if (!s.add(method)) continue;
            worklist.add(method);
        }
        return this.iterator(s, worklist);
    }

    private Iterator iterator(NumberedSet s, ArrayList worklist) {
        for (int i = 0; i < worklist.size(); ++i) {
            SootMethod method = (SootMethod)worklist.get(i);
            Iterator it = this.cg.edgesOutOf(method);
            if (this.filter != null) {
                it = this.filter.wrap(it);
            }
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                if (!s.add(e.tgt())) continue;
                worklist.add(e.tgt());
            }
        }
        return worklist.iterator();
    }
}

